/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.tileentity;

import com.pahimar.ee3.init.ModBlocks;
import com.pahimar.ee3.tileentity.TileEntityEE;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileEntityAlchemicalChest
extends TileEntityEE
implements IInventory {
    public float lidAngle;
    public float prevLidAngle;
    public int numUsingPlayers;
    private int ticksSinceSync;
    private ItemStack[] inventory;

    public TileEntityAlchemicalChest(int metaData) {
        this.state = (byte)metaData;
        if (metaData == 0) {
            this.inventory = new ItemStack[48];
        } else if (metaData == 1) {
            this.inventory = new ItemStack[84];
        } else if (metaData == 2) {
            this.inventory = new ItemStack[117];
        }
    }

    public int getSizeInventory() {
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slotIndex) {
        return this.inventory[slotIndex];
    }

    public ItemStack decrStackSize(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.getStackInSlot(slotIndex);
        if (itemStack != null) {
            if (itemStack.stackSize <= decrementAmount) {
                this.setInventorySlotContents(slotIndex, null);
            } else {
                itemStack = itemStack.splitStack(decrementAmount);
                if (itemStack.stackSize == 0) {
                    this.setInventorySlotContents(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack getStackInSlotOnClosing(int slotIndex) {
        if (this.inventory[slotIndex] != null) {
            ItemStack itemStack = this.inventory[slotIndex];
            this.inventory[slotIndex] = null;
            return itemStack;
        }
        return null;
    }

    public void setInventorySlotContents(int slotIndex, ItemStack itemStack) {
        this.inventory[slotIndex] = itemStack;
        if (itemStack != null && itemStack.stackSize > this.getInventoryStackLimit()) {
            itemStack.stackSize = this.getInventoryStackLimit();
        }
        this.markDirty();
    }

    public String getInventoryName() {
        return this.hasCustomName() ? this.getCustomName() : "container.ee3:alchemicalChest";
    }

    public boolean hasCustomInventoryName() {
        return this.hasCustomName();
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    public void openInventory() {
        ++this.numUsingPlayers;
        this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, (Block)ModBlocks.alchemicalChest, 1, this.numUsingPlayers);
    }

    public void closeInventory() {
        --this.numUsingPlayers;
        this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, (Block)ModBlocks.alchemicalChest, 1, this.numUsingPlayers);
    }

    public boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        return true;
    }

    public void updateEntity() {
        double adjustedZCoord;
        double adjustedXCoord;
        super.updateEntity();
        if (++this.ticksSinceSync % 20 * 4 == 0) {
            this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, (Block)ModBlocks.alchemicalChest, 1, this.numUsingPlayers);
        }
        this.prevLidAngle = this.lidAngle;
        float angleIncrement = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            adjustedXCoord = (double)this.xCoord + 0.5;
            adjustedZCoord = (double)this.zCoord + 0.5;
            this.worldObj.playSoundEffect(adjustedXCoord, (double)this.yCoord + 0.5, adjustedZCoord, "random.chestopen", 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float var8 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += angleIncrement) : (this.lidAngle -= angleIncrement);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && var8 >= 0.5f) {
                adjustedXCoord = (double)this.xCoord + 0.5;
                adjustedZCoord = (double)this.zCoord + 0.5;
                this.worldObj.playSoundEffect(adjustedXCoord, (double)this.yCoord + 0.5, adjustedZCoord, "random.chestclosed", 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean receiveClientEvent(int eventID, int numUsingPlayers) {
        if (eventID == 1) {
            this.numUsingPlayers = numUsingPlayers;
            return true;
        }
        return super.receiveClientEvent(eventID, numUsingPlayers);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        NBTTagList tagList = nbtTagCompound.getTagList("Items", 10);
        this.inventory = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound tagCompound = tagList.getCompoundTagAt(i);
            byte slotIndex = tagCompound.getByte("Slot");
            if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
            this.inventory[slotIndex] = ItemStack.loadItemStackFromNBT((NBTTagCompound)tagCompound);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        super.writeToNBT(nbtTagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.setByte("Slot", (byte)currentIndex);
            this.inventory[currentIndex].writeToNBT(tagCompound);
            tagList.appendTag((NBTBase)tagCompound);
        }
        nbtTagCompound.setTag("Items", (NBTBase)tagList);
    }
}

