/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.recipe;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.recipe.RecipesFluidContainers;
import com.pahimar.ee3.recipe.RecipesPotions;
import com.pahimar.ee3.recipe.RecipesVanilla;
import com.pahimar.ee3.util.LoaderHelper;
import com.pahimar.ee3.util.LogHelper;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.List;

public class RecipeRegistry {
    private static RecipeRegistry recipeRegistry = null;
    private Multimap<WrappedStack, List<WrappedStack>> recipeMap = HashMultimap.create();
    private ImmutableMultimap<WrappedStack, List<WrappedStack>> immutableRecipeMap;

    private RecipeRegistry() {
    }

    public static RecipeRegistry getInstance() {
        if (recipeRegistry == null) {
            recipeRegistry = new RecipeRegistry();
        }
        return recipeRegistry;
    }

    public void addRecipe(Object recipeOutput, List<?> recipeInputList) {
        WrappedStack wrappedRecipeOutput = WrappedStack.wrap(recipeOutput);
        if (wrappedRecipeOutput == null) {
            return;
        }
        ArrayList<WrappedStack> wrappedRecipeInputList = new ArrayList<WrappedStack>();
        StringBuilder stringBuilder = new StringBuilder();
        for (Object recipeInputObject : recipeInputList) {
            WrappedStack wrappedInputObject = WrappedStack.wrap(recipeInputObject);
            if (wrappedInputObject != null) {
                wrappedRecipeInputList.add(wrappedInputObject);
                stringBuilder.append(wrappedInputObject);
                stringBuilder.append(" ");
                continue;
            }
            return;
        }
        if (!this.recipeMap.get((Object)wrappedRecipeOutput).contains(wrappedRecipeInputList)) {
            LogHelper.trace(String.format("RecipeRegistry[%s]: Mod with ID '%s' added recipe (Output: %s, Inputs: %s)", LoaderHelper.getLoaderState(), Loader.instance().activeModContainer().getModId(), wrappedRecipeOutput, stringBuilder.toString().trim()));
            this.recipeMap.put((Object)wrappedRecipeOutput, wrappedRecipeInputList);
        }
    }

    public void registerVanillaRecipes() {
        RecipesVanilla.registerRecipes();
        RecipesFluidContainers.registerRecipes();
        RecipesPotions.registerRecipes();
    }

    public Multimap<WrappedStack, List<WrappedStack>> getRecipeMappings() {
        if (this.immutableRecipeMap == null) {
            this.immutableRecipeMap = ImmutableMultimap.copyOf(RecipeRegistry.recipeRegistry.recipeMap);
        }
        return this.immutableRecipeMap;
    }

    public void dumpRecipeRegistryToLog() {
        for (WrappedStack wrappedStack : this.getRecipeMappings().keySet()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.format("Output: %s, Inputs: ", wrappedStack.toString()));
            for (List listStacks : this.getRecipeMappings().get((Object)wrappedStack)) {
                for (WrappedStack listStack : listStacks) {
                    stringBuilder.append(listStack.toString() + " ");
                }
            }
            LogHelper.info(stringBuilder.toString());
        }
    }
}

