/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.network.message;

import com.pahimar.ee3.tileentity.TileEntityGlassBell;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class MessageTileEntityGlassBell
implements IMessage,
IMessageHandler<MessageTileEntityGlassBell, IMessage> {
    public int x;
    public int y;
    public int z;
    public byte orientation;
    public byte state;
    public String customName;
    public UUID ownerUUID;
    public ItemStack outputItemStack;

    public MessageTileEntityGlassBell() {
    }

    public MessageTileEntityGlassBell(TileEntityGlassBell tileEntityGlassBell, ItemStack outputItemStack) {
        this.x = tileEntityGlassBell.xCoord;
        this.y = tileEntityGlassBell.yCoord;
        this.z = tileEntityGlassBell.zCoord;
        this.orientation = (byte)tileEntityGlassBell.getOrientation().ordinal();
        this.state = (byte)tileEntityGlassBell.getState();
        this.customName = tileEntityGlassBell.getCustomName();
        this.ownerUUID = tileEntityGlassBell.getOwnerUUID();
        this.outputItemStack = outputItemStack;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.orientation = buf.readByte();
        this.state = buf.readByte();
        int customNameLength = buf.readInt();
        this.customName = new String(buf.readBytes(customNameLength).array());
        this.ownerUUID = buf.readBoolean() ? new UUID(buf.readLong(), buf.readLong()) : null;
        this.outputItemStack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte((int)this.orientation);
        buf.writeByte((int)this.state);
        buf.writeInt(this.customName.length());
        buf.writeBytes(this.customName.getBytes());
        if (this.ownerUUID != null) {
            buf.writeBoolean(true);
            buf.writeLong(this.ownerUUID.getMostSignificantBits());
            buf.writeLong(this.ownerUUID.getLeastSignificantBits());
        } else {
            buf.writeBoolean(false);
        }
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.outputItemStack);
    }

    public IMessage onMessage(MessageTileEntityGlassBell message, MessageContext ctx) {
        TileEntity tileEntity = FMLClientHandler.instance().getClient().theWorld.getTileEntity(message.x, message.y, message.z);
        if (tileEntity instanceof TileEntityGlassBell) {
            ((TileEntityGlassBell)tileEntity).setOrientation(message.orientation);
            ((TileEntityGlassBell)tileEntity).setState(message.state);
            ((TileEntityGlassBell)tileEntity).setCustomName(message.customName);
            ((TileEntityGlassBell)tileEntity).setOwnerUUID(message.ownerUUID);
            ((TileEntityGlassBell)tileEntity).outputItemStack = message.outputItemStack;
            FMLClientHandler.instance().getClient().theWorld.func_147451_t(message.x, message.y, message.z);
        }
        return null;
    }

    public String toString() {
        return String.format("MessageTileEntityGlassBell - x:%s, y:%s, z:%s, orientation:%s, state:%s, customName:%s, ownerUUID:%s, outputItemStack: %s", this.x, this.y, this.z, this.orientation, this.state, this.customName, this.ownerUUID, this.outputItemStack.toString());
    }
}

