/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.item;

import com.pahimar.ee3.creativetab.CreativeTab;
import com.pahimar.ee3.reference.Textures;
import com.pahimar.ee3.util.IChargeable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Set;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;

public class ItemToolEE
extends ItemTool {
    public ItemToolEE(float damageVsEntity, Item.ToolMaterial toolMaterial, Set blocksEffectiveAgainst) {
        super(damageVsEntity, toolMaterial, blocksEffectiveAgainst);
        this.setCreativeTab(CreativeTab.EE3_TAB);
        this.setNoRepair();
        this.maxStackSize = 1;
    }

    public String getUnlocalizedName() {
        return String.format("item.%s%s", Textures.RESOURCE_PREFIX, this.getUnwrappedUnlocalizedName(super.getUnlocalizedName()));
    }

    public String getUnlocalizedName(ItemStack itemStack) {
        return String.format("item.%s%s", Textures.RESOURCE_PREFIX, this.getUnwrappedUnlocalizedName(super.getUnlocalizedName()));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon(this.getUnlocalizedName().substring(this.getUnlocalizedName().indexOf(".") + 1));
    }

    protected String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }

    public boolean getShareTag() {
        return true;
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        if (itemStack.getItem() instanceof IChargeable) {
            return ((IChargeable)itemStack.getItem()).getChargeLevel(itemStack) > 0;
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        if (itemStack.getItem() instanceof IChargeable) {
            return (double)(((IChargeable)itemStack.getItem()).getMaxChargeLevel() - ((IChargeable)itemStack.getItem()).getChargeLevel(itemStack)) / (double)((IChargeable)itemStack.getItem()).getMaxChargeLevel();
        }
        return 1.0;
    }
}

