/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.item;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.pahimar.ee3.creativetab.CreativeTab;
import com.pahimar.ee3.item.ItemToolModalEE;
import com.pahimar.ee3.reference.Key;
import com.pahimar.ee3.reference.Material;
import com.pahimar.ee3.reference.ToolMode;
import com.pahimar.ee3.util.CommonSoundHelper;
import com.pahimar.ee3.util.IChargeable;
import com.pahimar.ee3.util.IKeyBound;
import com.pahimar.ee3.util.LogHelper;
import com.pahimar.ee3.util.NBTHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ItemDarkMatterPickAxe
extends ItemToolModalEE
implements IKeyBound,
IChargeable {
    private static final Set blocksEffectiveAgainst = Sets.newHashSet((Object[])new Block[]{Blocks.cobblestone, Blocks.double_stone_slab, Blocks.stone_slab, Blocks.stone, Blocks.sandstone, Blocks.mossy_cobblestone, Blocks.iron_ore, Blocks.iron_block, Blocks.coal_ore, Blocks.gold_block, Blocks.gold_ore, Blocks.diamond_ore, Blocks.diamond_block, Blocks.ice, Blocks.netherrack, Blocks.lapis_ore, Blocks.lapis_block, Blocks.redstone_ore, Blocks.lit_redstone_ore, Blocks.rail, Blocks.detector_rail, Blocks.golden_rail, Blocks.activator_rail});

    public ItemDarkMatterPickAxe() {
        super(2.0f, Material.Tools.DARK_MATTER, blocksEffectiveAgainst);
        this.setCreativeTab(CreativeTab.EE3_TAB);
        this.setNoRepair();
        this.setUnlocalizedName("pickAxeDarkMatter");
    }

    public boolean func_150897_b(Block block) {
        return block == Blocks.obsidian ? this.toolMaterial.getHarvestLevel() == 3 : (block != Blocks.diamond_block && block != Blocks.diamond_ore ? (block != Blocks.emerald_ore && block != Blocks.emerald_block ? (block != Blocks.gold_block && block != Blocks.gold_ore ? (block != Blocks.iron_block && block != Blocks.iron_ore ? (block != Blocks.lapis_block && block != Blocks.lapis_ore ? (block != Blocks.redstone_ore && block != Blocks.lit_redstone_ore ? block.getMaterial() == Material.rock || block.getMaterial() == Material.iron || block.getMaterial() == Material.anvil : this.toolMaterial.getHarvestLevel() >= 2) : this.toolMaterial.getHarvestLevel() >= 1) : this.toolMaterial.getHarvestLevel() >= 1) : this.toolMaterial.getHarvestLevel() >= 2) : this.toolMaterial.getHarvestLevel() >= 2) : this.toolMaterial.getHarvestLevel() >= 2);
    }

    public float func_150893_a(ItemStack itemStack, Block block) {
        return block.getMaterial() != Material.iron && block.getMaterial() != Material.anvil && block.getMaterial() != Material.rock ? super.func_150893_a(itemStack, block) : this.efficiencyOnProperMaterial;
    }

    public Set<String> getToolClasses(ItemStack itemStack) {
        return ImmutableSet.of((Object)"pickaxe");
    }

    public float getDigSpeed(ItemStack itemStack, Block block, int meta) {
        if ((ForgeHooks.isToolEffective((ItemStack)itemStack, (Block)block, (int)meta) || block == Blocks.obsidian || block == Blocks.redstone_ore || block == Blocks.lit_redstone_ore) && itemStack.getItem() instanceof IChargeable) {
            return super.getDigSpeed(itemStack, block, meta) + (float)((IChargeable)itemStack.getItem()).getChargeLevel(itemStack) * 12.0f;
        }
        return super.getDigSpeed(itemStack, block, meta);
    }

    public boolean onItemUse(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.isRemote) {
            LogHelper.info("Right click with the Dark Matter Pickaxe");
        }
        return false;
    }

    @Override
    public short getMaxChargeLevel() {
        return 3;
    }

    @Override
    public short getChargeLevel(ItemStack itemStack) {
        return NBTHelper.getShort(itemStack, "chargeLevel");
    }

    @Override
    public void setChargeLevel(ItemStack itemStack, short chargeLevel) {
        if (chargeLevel <= this.getMaxChargeLevel()) {
            NBTHelper.setShort(itemStack, "chargeLevel", chargeLevel);
        }
    }

    @Override
    public void increaseChargeLevel(ItemStack itemStack) {
        if (NBTHelper.getShort(itemStack, "chargeLevel") < this.getMaxChargeLevel()) {
            NBTHelper.setShort(itemStack, "chargeLevel", (short)(NBTHelper.getShort(itemStack, "chargeLevel") + 1));
        }
    }

    @Override
    public void decreaseChargeLevel(ItemStack itemStack) {
        if (NBTHelper.getShort(itemStack, "chargeLevel") > 0) {
            NBTHelper.setShort(itemStack, "chargeLevel", (short)(NBTHelper.getShort(itemStack, "chargeLevel") - 1));
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer entityPlayer, ItemStack itemStack, Key key) {
        if (key == Key.CHARGE) {
            if (!entityPlayer.isSneaking()) {
                if (this.getChargeLevel(itemStack) == this.getMaxChargeLevel()) {
                    CommonSoundHelper.playSoundAtPlayer(entityPlayer, "fail", 1.5f, 1.5f);
                } else {
                    this.increaseChargeLevel(itemStack);
                    CommonSoundHelper.playSoundAtPlayer(entityPlayer, "chargeUp", 0.5f, 0.5f + 0.5f * ((float)this.getChargeLevel(itemStack) * 1.0f / (float)this.getMaxChargeLevel()));
                }
            } else if (this.getChargeLevel(itemStack) == 0) {
                CommonSoundHelper.playSoundAtPlayer(entityPlayer, "fail", 1.5f, 1.5f);
            } else {
                this.decreaseChargeLevel(itemStack);
                CommonSoundHelper.playSoundAtPlayer(entityPlayer, "chargeDown", 0.5f, 1.0f - (0.5f - 0.5f * ((float)this.getChargeLevel(itemStack) * 1.0f / (float)this.getMaxChargeLevel())));
            }
        } else if (key == Key.EXTRA) {
            CommonSoundHelper.playSoundAtPlayer(entityPlayer, "tock", 0.5f, 1.5f);
            this.changeToolMode(itemStack);
        }
    }

    @Override
    public List<ToolMode> getAvailableToolModes() {
        return Arrays.asList(ToolMode.STANDARD, ToolMode.WIDE, ToolMode.TALL);
    }
}

