/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.item;

import com.pahimar.ee3.item.ItemEE;
import com.pahimar.ee3.reference.Names;
import com.pahimar.ee3.reference.Textures;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;

public class ItemAlchemicalInventoryUpgrade
extends ItemEE {
    public ItemAlchemicalInventoryUpgrade() {
        this.setMaxStackSize(64);
        this.setUnlocalizedName("alchemicalUpgrade");
        this.setHasSubtypes(true);
    }

    @Override
    public String getUnlocalizedName() {
        return String.format("item.%s%s", Textures.RESOURCE_PREFIX, "alchemicalUpgrade");
    }

    @Override
    public String getUnlocalizedName(ItemStack itemStack) {
        return String.format("item.%s%s.%s", Textures.RESOURCE_PREFIX, "alchemicalUpgrade", Names.Items.ALCHEMICAL_UPGRADE_SUBTYPES[MathHelper.clamp_int((int)itemStack.getItemDamage(), (int)0, (int)(Names.Items.ALCHEMICAL_UPGRADE_SUBTYPES.length - 1))]);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs creativeTab, List list) {
        for (int meta = 0; meta < Names.Items.ALCHEMICAL_UPGRADE_SUBTYPES.length; ++meta) {
            list.add(new ItemStack((Item)this, 1, meta));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack itemStack, int renderPass) {
        if (itemStack.getItemDamage() == 0) {
            return Integer.parseInt("45CC39", 16);
        }
        if (itemStack.getItemDamage() == 1) {
            return Integer.parseInt("35A6DE", 16);
        }
        if (itemStack.getItemDamage() == 2) {
            return Integer.parseInt("FF4545", 16);
        }
        return Integer.parseInt("ffffff", 16);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean flag) {
        list.add(StatCollector.translateToLocal((String)"tooltip.ee3:upgradesPrefix"));
    }

    public String getItemStackDisplayName(ItemStack itemStack) {
        switch (MathHelper.clamp_int((int)itemStack.getItemDamage(), (int)0, (int)(Names.Items.ALCHEMICAL_UPGRADE_SUBTYPES.length - 1))) {
            case 0: {
                return EnumChatFormatting.GREEN + super.getItemStackDisplayName(itemStack);
            }
            case 1: {
                return EnumChatFormatting.BLUE + super.getItemStackDisplayName(itemStack);
            }
            case 2: {
                return EnumChatFormatting.RED + super.getItemStackDisplayName(itemStack);
            }
        }
        return EnumChatFormatting.WHITE + super.getItemStackDisplayName(itemStack);
    }
}

