/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.item;

import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.item.ItemEE;
import com.pahimar.ee3.reference.GUIs;
import com.pahimar.ee3.reference.Textures;
import com.pahimar.ee3.util.ColorHelper;
import com.pahimar.ee3.util.IOwnable;
import com.pahimar.ee3.util.ItemHelper;
import com.pahimar.ee3.util.NBTHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemAlchemicalBag
extends ItemEE
implements IOwnable {
    private static final String[] ALCHEMICAL_BAG_ICONS = new String[]{"open", "closed", "symbolTier1", "symbolTier2", "symbolTier3"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemAlchemicalBag() {
        this.setHasSubtypes(true);
        this.setUnlocalizedName("alchemicalBag");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[ALCHEMICAL_BAG_ICONS.length];
        for (int i = 0; i < ALCHEMICAL_BAG_ICONS.length; ++i) {
            this.icons[i] = iconRegister.registerIcon(Textures.RESOURCE_PREFIX + "alchemicalBag" + "." + ALCHEMICAL_BAG_ICONS[i]);
        }
    }

    public IIcon getIcon(ItemStack itemStack, int renderPass) {
        if (renderPass == 0) {
            if (NBTHelper.hasTag(itemStack, "alchemicalBagGuiOpen")) {
                return this.icons[0];
            }
            return this.icons[1];
        }
        return this.icons[2 + MathHelper.clamp_int((int)itemStack.getItemDamage(), (int)0, (int)3)];
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs creativeTab, List list) {
        for (int meta = 0; meta < 3; ++meta) {
            list.add(new ItemStack((Item)this, 1, meta));
        }
    }

    public boolean getShareTag() {
        return true;
    }

    public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (!world.isRemote) {
            if (!ItemHelper.hasOwnerUUID(itemStack)) {
                ItemHelper.setOwner(itemStack, entityPlayer);
                entityPlayer.addChatComponentMessage((IChatComponent)new ChatComponentTranslation("misc.ee3:owner-set-to-self", new Object[]{itemStack.func_151000_E()}));
            }
            NBTHelper.setUUID(itemStack);
            NBTHelper.setBoolean(itemStack, "alchemicalBagGuiOpen", true);
            entityPlayer.openGui((Object)EquivalentExchange3.instance, GUIs.ALCHEMICAL_BAG.ordinal(), entityPlayer.worldObj, (int)entityPlayer.posX, (int)entityPlayer.posY, (int)entityPlayer.posZ);
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack itemStack, int renderPass) {
        int bagColor = this.getColor(itemStack);
        if (bagColor < 0) {
            bagColor = Integer.parseInt("ffffff", 16);
        }
        return bagColor;
    }

    public boolean hasColor(ItemStack itemStack) {
        return ColorHelper.hasColor(itemStack);
    }

    public int getColor(ItemStack itemStack) {
        return ColorHelper.getColor(itemStack);
    }

    public void setColor(ItemStack itemStack, int color) {
        if (itemStack != null && itemStack.getItem() instanceof ItemAlchemicalBag) {
            ColorHelper.setColor(itemStack, color);
        }
    }

    public void removeColor(ItemStack itemStack) {
        NBTTagCompound displayTagCompound;
        NBTTagCompound nbtTagCompound;
        if (itemStack != null && (nbtTagCompound = itemStack.getTagCompound()) != null && (displayTagCompound = nbtTagCompound.getCompoundTag("display")).hasKey("color")) {
            displayTagCompound.removeTag("color");
        }
    }
}

