/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.inventory;

import com.pahimar.ee3.reference.Comparators;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryAlchemicalTome
implements IInventory {
    private ItemStack[] inventory = new ItemStack[80];
    private Set<ItemStack> knownTransmutations;

    public InventoryAlchemicalTome(Set<ItemStack> knownTransmutations) {
        this.knownTransmutations = knownTransmutations != null ? knownTransmutations : new TreeSet<ItemStack>(Comparators.idComparator);
        this.inventory = knownTransmutations.toArray(this.inventory);
    }

    public int getSizeInventory() {
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slotIndex) {
        if (slotIndex < this.getSizeInventory()) {
            return this.inventory[slotIndex];
        }
        return null;
    }

    public ItemStack decrStackSize(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.getStackInSlot(slotIndex);
        if (itemStack != null) {
            if (itemStack.stackSize <= decrementAmount) {
                this.setInventorySlotContents(slotIndex, null);
            } else {
                itemStack = itemStack.splitStack(decrementAmount);
                if (itemStack.stackSize == 0) {
                    this.setInventorySlotContents(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack getStackInSlotOnClosing(int slotIndex) {
        if (this.getStackInSlot(slotIndex) != null) {
            ItemStack itemStack = this.inventory[slotIndex];
            this.inventory[slotIndex] = null;
            return itemStack;
        }
        return null;
    }

    public void setInventorySlotContents(int slotIndex, ItemStack itemStack) {
        if (slotIndex < this.inventory.length) {
            this.inventory[slotIndex] = itemStack;
        }
    }

    public String getInventoryName() {
        return "container.ee3:alchemicalTome";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
    }

    public boolean isUseableByPlayer(EntityPlayer entityPlayer) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        return false;
    }

    public Set<ItemStack> getKnownTransmutations() {
        return this.knownTransmutations;
    }
}

