/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.inventory;

import com.pahimar.ee3.inventory.ContainerEE;
import com.pahimar.ee3.tileentity.TileEntityCalcinator;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public class ContainerCalcinator
extends ContainerEE {
    private TileEntityCalcinator tileEntityCalcinator;
    private int lastCookTime;
    private int lastBurnTime;
    private int lastItemCookTime;

    public ContainerCalcinator(InventoryPlayer inventoryPlayer, TileEntityCalcinator tileEntityCalcinator) {
        this.tileEntityCalcinator = tileEntityCalcinator;
        this.addSlotToContainer(new Slot((IInventory)tileEntityCalcinator, 0, 45, 55));
        this.addSlotToContainer(new Slot((IInventory)tileEntityCalcinator, 1, 45, 10));
        this.addSlotToContainer(new SlotCalcinator((IInventory)tileEntityCalcinator, 2, 105, 29));
        this.addSlotToContainer(new SlotCalcinator((IInventory)tileEntityCalcinator, 3, 125, 29));
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, 8 + inventoryColumnIndex * 18, 94 + inventoryRowIndex * 18));
            }
        }
        for (int actionBarSlotIndex = 0; actionBarSlotIndex < 9; ++actionBarSlotIndex) {
            this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, actionBarSlotIndex, 8 + actionBarSlotIndex * 18, 152));
        }
    }

    public void addCraftingToCrafters(ICrafting iCrafting) {
        super.addCraftingToCrafters(iCrafting);
        iCrafting.sendProgressBarUpdate((Container)this, 0, this.tileEntityCalcinator.deviceCookTime);
        iCrafting.sendProgressBarUpdate((Container)this, 1, this.tileEntityCalcinator.fuelBurnTime);
        iCrafting.sendProgressBarUpdate((Container)this, 2, this.tileEntityCalcinator.itemCookTime);
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (Object crafter : this.crafters) {
            ICrafting icrafting = (ICrafting)crafter;
            if (this.lastCookTime != this.tileEntityCalcinator.deviceCookTime) {
                icrafting.sendProgressBarUpdate((Container)this, 0, this.tileEntityCalcinator.deviceCookTime);
            }
            if (this.lastBurnTime != this.tileEntityCalcinator.fuelBurnTime) {
                icrafting.sendProgressBarUpdate((Container)this, 1, this.tileEntityCalcinator.fuelBurnTime);
            }
            if (this.lastItemCookTime == this.tileEntityCalcinator.itemCookTime) continue;
            icrafting.sendProgressBarUpdate((Container)this, 2, this.tileEntityCalcinator.itemCookTime);
        }
        this.lastCookTime = this.tileEntityCalcinator.deviceCookTime;
        this.lastBurnTime = this.tileEntityCalcinator.fuelBurnTime;
        this.lastItemCookTime = this.tileEntityCalcinator.itemCookTime;
    }

    public ItemStack transferStackInSlot(EntityPlayer entityPlayer, int slotIndex) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        if (slot != null && slot.getHasStack()) {
            ItemStack slotItemStack = slot.getStack();
            itemStack = slotItemStack.copy();
            if (slotIndex < 4 ? !this.mergeItemStack(slotItemStack, 4, this.inventorySlots.size(), false) : (TileEntityFurnace.isItemFuel((ItemStack)slotItemStack) ? !this.mergeItemStack(slotItemStack, 0, 2, false) : !this.mergeItemStack(slotItemStack, 1, 2, false))) {
                return null;
            }
            if (slotItemStack.stackSize == 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int valueType, int updatedValue) {
        if (valueType == 0) {
            this.tileEntityCalcinator.deviceCookTime = updatedValue;
        }
        if (valueType == 1) {
            this.tileEntityCalcinator.fuelBurnTime = updatedValue;
        }
        if (valueType == 2) {
            this.tileEntityCalcinator.itemCookTime = updatedValue;
        }
    }

    private class SlotCalcinator
    extends Slot {
        public SlotCalcinator(IInventory inventory, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
        }

        public void onPickupFromSlot(EntityPlayer entityPlayer, ItemStack itemStack) {
            super.onPickupFromSlot(entityPlayer, itemStack);
            FMLCommonHandler.instance().firePlayerCraftingEvent(entityPlayer, itemStack, this.inventory);
        }

        public boolean isItemValid(ItemStack itemStack) {
            return false;
        }
    }
}

