/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.inventory;

import com.pahimar.ee3.inventory.ContainerEE;
import com.pahimar.ee3.item.ItemAlchemicalDust;
import com.pahimar.ee3.tileentity.TileEntityAludel;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public class ContainerAludel
extends ContainerEE {
    private TileEntityAludel tileEntityAludel;
    private int lastDeviceCookTime;
    private int lastFuelBurnTime;
    private int lastItemCookTime;

    public ContainerAludel(InventoryPlayer inventoryPlayer, TileEntityAludel tileEntityAludel) {
        this.tileEntityAludel = tileEntityAludel;
        this.addSlotToContainer(new Slot((IInventory)tileEntityAludel, 0, 44, 74));
        this.addSlotToContainer(new Slot((IInventory)tileEntityAludel, 1, 44, 18));
        this.addSlotToContainer(new Slot((IInventory)tileEntityAludel, 2, 44, 39));
        this.addSlotToContainer(new Slot((IInventory)tileEntityAludel, 3, 120, 39){

            public void onPickupFromSlot(EntityPlayer entityPlayer, ItemStack itemStack) {
                super.onPickupFromSlot(entityPlayer, itemStack);
                FMLCommonHandler.instance().firePlayerCraftingEvent(entityPlayer, itemStack, this.inventory);
            }

            public boolean isItemValid(ItemStack itemStack) {
                return false;
            }
        });
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, 8 + inventoryColumnIndex * 18, 106 + inventoryRowIndex * 18));
            }
        }
        for (int actionBarSlotIndex = 0; actionBarSlotIndex < 9; ++actionBarSlotIndex) {
            this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, actionBarSlotIndex, 8 + actionBarSlotIndex * 18, 164));
        }
    }

    public void addCraftingToCrafters(ICrafting iCrafting) {
        super.addCraftingToCrafters(iCrafting);
        iCrafting.sendProgressBarUpdate((Container)this, 0, this.tileEntityAludel.deviceCookTime);
        iCrafting.sendProgressBarUpdate((Container)this, 1, this.tileEntityAludel.fuelBurnTime);
        iCrafting.sendProgressBarUpdate((Container)this, 2, this.tileEntityAludel.itemCookTime);
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (Object crafter : this.crafters) {
            ICrafting icrafting = (ICrafting)crafter;
            if (this.lastDeviceCookTime != this.tileEntityAludel.deviceCookTime) {
                icrafting.sendProgressBarUpdate((Container)this, 0, this.tileEntityAludel.deviceCookTime);
            }
            if (this.lastFuelBurnTime != this.tileEntityAludel.fuelBurnTime) {
                icrafting.sendProgressBarUpdate((Container)this, 1, this.tileEntityAludel.fuelBurnTime);
            }
            if (this.lastItemCookTime == this.tileEntityAludel.itemCookTime) continue;
            icrafting.sendProgressBarUpdate((Container)this, 2, this.tileEntityAludel.itemCookTime);
        }
        this.lastDeviceCookTime = this.tileEntityAludel.deviceCookTime;
        this.lastFuelBurnTime = this.tileEntityAludel.fuelBurnTime;
        this.lastItemCookTime = this.tileEntityAludel.itemCookTime;
    }

    public ItemStack transferStackInSlot(EntityPlayer entityPlayer, int slotIndex) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        if (slot != null && slot.getHasStack()) {
            ItemStack slotItemStack = slot.getStack();
            itemStack = slotItemStack.copy();
            if (slotIndex < 4 ? !this.mergeItemStack(slotItemStack, 4, this.inventorySlots.size(), false) : (TileEntityFurnace.isItemFuel((ItemStack)slotItemStack) ? !this.mergeItemStack(slotItemStack, 0, 3, false) : (slotItemStack.getItem() instanceof ItemAlchemicalDust ? !this.mergeItemStack(slotItemStack, 2, 3, false) : !this.mergeItemStack(slotItemStack, 1, 2, false)))) {
                return null;
            }
            if (slotItemStack.stackSize == 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int valueType, int updatedValue) {
        if (valueType == 0) {
            this.tileEntityAludel.deviceCookTime = updatedValue;
        }
        if (valueType == 1) {
            this.tileEntityAludel.fuelBurnTime = updatedValue;
        }
        if (valueType == 2) {
            this.tileEntityAludel.itemCookTime = updatedValue;
        }
    }
}

