/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.inventory;

import com.pahimar.ee3.inventory.ContainerEE;
import com.pahimar.ee3.inventory.InventoryAlchemicalTome;
import com.pahimar.ee3.inventory.element.IElementButtonHandler;
import com.pahimar.ee3.inventory.element.IElementTextFieldHandler;
import com.pahimar.ee3.item.ItemAlchemicalTome;
import com.pahimar.ee3.knowledge.TransmutationKnowledgeRegistry;
import com.pahimar.ee3.reference.Comparators;
import com.pahimar.ee3.util.FilterUtils;
import com.pahimar.ee3.util.ItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerAlchemicalTome
extends ContainerEE
implements IElementButtonHandler,
IElementTextFieldHandler {
    private final InventoryAlchemicalTome inventoryAlchemicalTome;
    private int pageOffset;
    private int maxPageOffset;
    private String searchTerm;
    private boolean requiresUpdate = false;
    private static final int MAX_ROW_INDEX = 8;
    private static final int MAX_COLUMN_INDEX = 5;

    public ContainerAlchemicalTome(EntityPlayer entityPlayer, ItemStack itemStack) {
        int columnIndex;
        int rowIndex;
        TreeSet<ItemStack> knownTransmutations = new TreeSet<ItemStack>(Comparators.displayNameComparator);
        if (itemStack.getItem() instanceof ItemAlchemicalTome && ItemHelper.hasOwnerUUID(itemStack)) {
            UUID ownerUUID = ItemHelper.getOwnerUUID(itemStack);
            knownTransmutations.addAll(TransmutationKnowledgeRegistry.getInstance().getPlayersKnownTransmutations(ownerUUID));
        }
        this.inventoryAlchemicalTome = new InventoryAlchemicalTome(knownTransmutations);
        this.pageOffset = 0;
        this.maxPageOffset = knownTransmutations.size() / 80;
        int i = 0;
        for (rowIndex = 0; rowIndex < 8; ++rowIndex) {
            for (columnIndex = 0; columnIndex < 5; ++columnIndex) {
                this.addSlotToContainer(new Slot(this.inventoryAlchemicalTome, i, 18 + columnIndex * 20, 18 + rowIndex * 19){

                    public boolean canTakeStack(EntityPlayer player) {
                        return false;
                    }

                    @SideOnly(value=Side.CLIENT)
                    public boolean func_111238_b() {
                        return false;
                    }
                });
                ++i;
            }
        }
        i = 40;
        for (rowIndex = 0; rowIndex < 8; ++rowIndex) {
            for (columnIndex = 0; columnIndex < 5; ++columnIndex) {
                this.addSlotToContainer(new Slot(this.inventoryAlchemicalTome, i, 140 + columnIndex * 20, 18 + rowIndex * 19){

                    public boolean canTakeStack(EntityPlayer player) {
                        return false;
                    }

                    @SideOnly(value=Side.CLIENT)
                    public boolean func_111238_b() {
                        return false;
                    }
                });
                ++i;
            }
        }
    }

    public void addCraftingToCrafters(ICrafting iCrafting) {
        super.addCraftingToCrafters(iCrafting);
        iCrafting.sendProgressBarUpdate((Container)this, 0, this.pageOffset);
        iCrafting.sendProgressBarUpdate((Container)this, 1, this.maxPageOffset);
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.requiresUpdate) {
            for (Object crafter : this.crafters) {
                ICrafting icrafting = (ICrafting)crafter;
                icrafting.sendProgressBarUpdate((Container)this, 0, this.pageOffset);
                icrafting.sendProgressBarUpdate((Container)this, 1, this.maxPageOffset);
            }
            this.requiresUpdate = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int valueType, int updatedValue) {
        if (valueType == 0) {
            this.pageOffset = updatedValue;
        } else if (valueType == 1) {
            this.maxPageOffset = updatedValue;
        }
    }

    public int getInventorySize() {
        return this.inventoryAlchemicalTome.getSizeInventory();
    }

    public int getKnownTransmutationsCount() {
        return this.inventoryAlchemicalTome.getKnownTransmutations().size();
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public int getMaxPageOffset() {
        return this.maxPageOffset;
    }

    @Override
    public void handleElementButtonClick(String elementName, int mouseButton) {
        if (elementName.equalsIgnoreCase("prev") && mouseButton == 0 && this.pageOffset > 0) {
            --this.pageOffset;
            this.updateInventory();
        } else if (elementName.equalsIgnoreCase("next") && mouseButton == 0 && this.pageOffset < this.maxPageOffset) {
            ++this.pageOffset;
            this.updateInventory();
        }
    }

    @Override
    public void handleElementTextFieldUpdate(String elementName, String updatedText) {
        if (elementName.equalsIgnoreCase("searchField")) {
            this.searchTerm = updatedText;
            this.pageOffset = 0;
            this.updateInventory();
        }
    }

    private void updateInventory() {
        this.requiresUpdate = true;
        boolean shouldUpdateInventory = false;
        ItemStack[] newInventory = new ItemStack[80];
        ArrayList<ItemStack> filteredList = new ArrayList<ItemStack>(FilterUtils.filterByNameContains(this.inventoryAlchemicalTome.getKnownTransmutations(), this.searchTerm, Comparators.displayNameComparator));
        this.maxPageOffset = filteredList.size() / 80;
        if (this.pageOffset > this.maxPageOffset) {
            this.pageOffset = 0;
        }
        if (this.pageOffset == 0) {
            if (filteredList.size() <= 80) {
                newInventory = filteredList.toArray(newInventory);
                shouldUpdateInventory = true;
            } else {
                newInventory = filteredList.subList(0, 80).toArray(newInventory);
                shouldUpdateInventory = true;
            }
        } else if (this.pageOffset < this.maxPageOffset) {
            newInventory = filteredList.subList(this.pageOffset * 80, (this.pageOffset + 1) * 80).toArray(newInventory);
            shouldUpdateInventory = true;
        } else if (this.pageOffset == this.maxPageOffset) {
            newInventory = filteredList.subList(this.pageOffset * 80, filteredList.size() - 1).toArray(newInventory);
            shouldUpdateInventory = true;
        }
        if (shouldUpdateInventory) {
            for (int i = 0; i < 80; ++i) {
                this.inventoryAlchemicalTome.setInventorySlotContents(i, newInventory[i]);
                this.inventoryAlchemicalTome.markDirty();
            }
        }
    }
}

