/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.handler;

import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.knowledge.TransmutationKnowledgeRegistry;
import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.network.message.MessageChalkSettings;
import com.pahimar.ee3.network.message.MessageSyncEnergyValues;
import com.pahimar.ee3.settings.ChalkSettings;
import com.pahimar.ee3.util.EntityHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class PlayerEventHandler {
    @SubscribeEvent
    public void onPlayerLoadFromFileEvent(PlayerEvent.LoadFromFile event) {
        if (!event.entityPlayer.worldObj.isRemote) {
            TransmutationKnowledgeRegistry.getInstance().loadPlayerFromDiskIfNeeded(event.entityPlayer);
        }
    }

    @SubscribeEvent
    public void onPlayerSaveToFileEvent(PlayerEvent.SaveToFile event) {
        if (!event.entityPlayer.worldObj.isRemote) {
            TransmutationKnowledgeRegistry.getInstance().savePlayerKnowledgeToDisk(event.entityPlayer);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player != null) {
            NBTTagCompound playerCustomData = EntityHelper.getCustomEntityData((Entity)event.player);
            ChalkSettings chalkSettings = new ChalkSettings();
            chalkSettings.readFromNBT(playerCustomData);
            chalkSettings.writeToNBT(playerCustomData);
            EntityHelper.saveCustomEntityData((Entity)event.player, playerCustomData);
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageChalkSettings(chalkSettings), (EntityPlayerMP)event.player);
            TransmutationKnowledgeRegistry.getInstance().loadPlayerFromDiskIfNeeded(event.player);
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncEnergyValues(EnergyValueRegistry.getInstance()), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.player.worldObj.isRemote) {
            TransmutationKnowledgeRegistry.getInstance().unloadPlayer(event.player);
        }
    }
}

