/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.handler;

import com.pahimar.ee3.reference.Settings;
import com.pahimar.ee3.util.ConfigurationHelper;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    public static Configuration configuration;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        Settings.General.syncThreshold = configuration.getInt("sync.threshold", "general", 5, 0, Short.MAX_VALUE, StatCollector.translateToLocal((String)"general.sync.threshold.comment"), "general.sync.threshold.label");
        Settings.Sounds.soundMode = ConfigurationHelper.getString(configuration, "soundMode", "general", "All", StatCollector.translateToLocal((String)"general.sound.soundMode.comment"), new String[]{"All", "Self", "None"}, "general.sound.soundMode.label");
        Settings.Abilities.onlyLoadFile = configuration.getBoolean("abilities.onlyLoadFile", "general", false, StatCollector.translateToLocal((String)"general.abilities.onlyLoadFile.comment"), "general.abilities.onlyLoadFile.label");
        Settings.DynamicEnergyValueGeneration.regenerateEnergyValuesWhen = ConfigurationHelper.getString(configuration, "energyvalues.regenerateEnergyValuesWhen", "general", "When Mods Change", StatCollector.translateToLocal((String)"general.energyvalues.regenerateEnergyValuesWhen.comment"), new String[]{"Never", "When Mods Change", "Always"}, "general.energyvalues.regenerateEnergyValuesWhen.label");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("EE3")) {
            ConfigurationHandler.loadConfiguration();
        }
    }
}

