/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.exchange;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class JsonItemStack
implements JsonSerializer<JsonItemStack>,
JsonDeserializer<JsonItemStack> {
    public static final Gson jsonSerializer = new GsonBuilder().registerTypeAdapter(JsonItemStack.class, (Object)new JsonItemStack()).create();
    public String itemName;
    public int itemDamage;
    public NBTTagCompound itemNBTTagCompound;

    public JsonItemStack() {
        this.itemName = null;
        this.itemDamage = 0;
        this.itemNBTTagCompound = null;
    }

    public JsonItemStack(ItemStack itemStack) {
        this.itemName = Item.itemRegistry.getNameForObject((Object)itemStack.getItem());
        this.itemDamage = itemStack.getItemDamage();
        if (itemStack.stackTagCompound != null) {
            this.itemNBTTagCompound = itemStack.getTagCompound();
        }
    }

    public JsonItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            JsonObject jsonObject = (JsonObject)json;
            JsonItemStack jsonItemStack = new JsonItemStack();
            if (!jsonObject.has("itemName")) {
                throw new JsonParseException("");
            }
            jsonItemStack.itemName = jsonObject.get("itemName").getAsString();
            if (!jsonObject.has("itemDamage")) {
                throw new JsonParseException("");
            }
            jsonItemStack.itemDamage = jsonObject.get("itemDamage").getAsInt();
            if (jsonObject.has("itemNBTTagCompound")) {
                try {
                    NBTBase nbtBase = JsonToNBT.func_150315_a((String)jsonObject.get("itemNBTTagCompound").getAsString());
                    if (nbtBase instanceof NBTTagCompound) {
                        jsonItemStack.itemNBTTagCompound = (NBTTagCompound)nbtBase;
                    }
                }
                catch (NBTException e) {
                    throw new JsonParseException(e.getMessage(), e.getCause());
                }
            }
            return jsonItemStack;
        }
        return null;
    }

    public JsonElement serialize(JsonItemStack src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("itemName", src.itemName);
        jsonObject.addProperty("itemDamage", (Number)src.itemDamage);
        if (src.itemNBTTagCompound != null) {
            jsonObject.addProperty("itemNBTTagCompound", src.itemNBTTagCompound.toString());
        }
        return jsonObject;
    }

    public String toString() {
        return String.format("itemName: %s, itemDamage: %s, itemNBTTagCompound: %s", this.itemName, this.itemDamage, this.itemNBTTagCompound);
    }
}

