/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.command;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.network.message.MessageSetEnergyValue;
import com.pahimar.ee3.util.SerializationHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class CommandSetEnergyValueCurrentItem
extends CommandBase {
    public String getCommandName() {
        return "set-energy-value-current-item";
    }

    public int getRequiredPermissionLevel() {
        return 2;
    }

    public String getCommandUsage(ICommandSender commandSender) {
        return "commands.ee3.set-energy-value-current-item.usage";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processCommand(ICommandSender commandSender, String[] args) {
        ItemStack itemStack;
        if (args.length < 3) {
            throw new WrongUsageException("commands.ee3.set-energy-value-current-item.usage", new Object[0]);
        }
        float energyValue = 0.0f;
        if (args.length >= 3) {
            energyValue = (float)CommandSetEnergyValueCurrentItem.parseDoubleWithMin((ICommandSender)commandSender, (String)args[2], (double)0.0);
        }
        if ((itemStack = ((EntityPlayer)commandSender).getCurrentEquippedItem()) == null) throw new WrongUsageException("commands.ee3.no-item.error", new Object[0]);
        WrappedStack wrappedStack = WrappedStack.wrap(itemStack);
        EnergyValue newEnergyValue = new EnergyValue(energyValue);
        if (wrappedStack == null || newEnergyValue == null || Float.compare(newEnergyValue.getValue(), 0.0f) <= 0) throw new WrongUsageException("commands.ee3.set-energy-value-current-item.usage", new Object[0]);
        if (args[1].equalsIgnoreCase("pre")) {
            Map<WrappedStack, EnergyValue> preAssignedValues = SerializationHelper.readEnergyValueStackMapFromJsonFile("pre-assigned-energy-values.json");
            preAssignedValues.put(wrappedStack, newEnergyValue);
            SerializationHelper.writeEnergyValueStackMapToJsonFile("pre-assigned-energy-values.json", preAssignedValues);
            EnergyValueRegistry.getInstance().setShouldRegenNextRestart(true);
        } else if (args[1].equalsIgnoreCase("post")) {
            EnergyValueRegistry.getInstance().setEnergyValue(wrappedStack, newEnergyValue);
            Map<WrappedStack, EnergyValue> postAssignedValues = SerializationHelper.readEnergyValueStackMapFromJsonFile("post-assigned-energy-values.json");
            postAssignedValues.put(wrappedStack, newEnergyValue);
            SerializationHelper.writeEnergyValueStackMapToJsonFile("post-assigned-energy-values.json", postAssignedValues);
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageSetEnergyValue(wrappedStack, newEnergyValue));
        }
        CommandSetEnergyValueCurrentItem.func_152373_a((ICommandSender)commandSender, (ICommand)this, (String)"commands.ee3.set-energy-value-current-item.success", (Object[])new Object[]{commandSender.getCommandSenderName(), args[1], itemStack.func_151000_E(), newEnergyValue.getChatComponent()});
    }

    public List addTabCompletionOptions(ICommandSender commandSender, String[] args) {
        if (args.length == 2) {
            return CommandSetEnergyValueCurrentItem.getListOfStringsMatchingLastWord((String[])args, (String[])new String[]{"pre", "post"});
        }
        return null;
    }
}

