/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.command;

import com.pahimar.ee3.knowledge.AbilityRegistry;
import com.pahimar.ee3.knowledge.TransmutationKnowledgeRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CommandPlayerLearnItem
extends CommandBase {
    public String getCommandName() {
        return "player-learn-item";
    }

    public int getRequiredPermissionLevel() {
        return 2;
    }

    public String getCommandUsage(ICommandSender commandSender) {
        return "commands.ee3.player-learn-item.usage";
    }

    public void processCommand(ICommandSender commandSender, String[] args) {
        if (args.length < 3) {
            throw new WrongUsageException("commands.ee3.player-learn-item.usage", new Object[0]);
        }
        EntityPlayerMP entityPlayer = CommandPlayerLearnItem.getPlayer((ICommandSender)commandSender, (String)args[1]);
        if (entityPlayer != null) {
            Item item = CommandPlayerLearnItem.getItemByText((ICommandSender)commandSender, (String)args[2]);
            int metaData = 0;
            if (args.length >= 4) {
                metaData = CommandPlayerLearnItem.parseInt((ICommandSender)commandSender, (String)args[3]);
            }
            ItemStack itemStack = new ItemStack(item, 1, metaData);
            if (args.length >= 5) {
                String stringNBTData = CommandPlayerLearnItem.func_147178_a((ICommandSender)commandSender, (String[])args, (int)4).getUnformattedText();
                try {
                    NBTBase nbtBase = JsonToNBT.func_150315_a((String)stringNBTData);
                    if (!(nbtBase instanceof NBTTagCompound)) {
                        CommandPlayerLearnItem.func_152373_a((ICommandSender)commandSender, (ICommand)this, (String)"commands.ee3.invalid-nbt-tag.error", (Object[])new Object[]{"Not a valid tag"});
                        return;
                    }
                    itemStack.setTagCompound((NBTTagCompound)nbtBase);
                }
                catch (Exception exception) {
                    CommandPlayerLearnItem.func_152373_a((ICommandSender)commandSender, (ICommand)this, (String)"commands.ee3.invalid-nbt-tag.error", (Object[])new Object[]{exception.getMessage()});
                    return;
                }
            }
            if (AbilityRegistry.getInstance().isLearnable(itemStack)) {
                TransmutationKnowledgeRegistry.getInstance().teachPlayer((EntityPlayer)entityPlayer, itemStack);
                CommandPlayerLearnItem.func_152373_a((ICommandSender)commandSender, (ICommand)this, (String)"commands.ee3.player-learn-item.success", (Object[])new Object[]{commandSender.getCommandSenderName(), entityPlayer.getCommandSenderName(), itemStack.func_151000_E()});
            }
        } else {
            throw new WrongUsageException("commands.ee3.player-not-found.error", new Object[0]);
        }
    }

    public List addTabCompletionOptions(ICommandSender commandSender, String[] args) {
        if (args.length == 2) {
            return CommandPlayerLearnItem.getListOfStringsMatchingLastWord((String[])args, (String[])FMLCommonHandler.instance().getMinecraftServerInstance().getAllUsernames());
        }
        if (args.length == 3) {
            return CommandPlayerLearnItem.getListOfStringsFromIterableMatchingLastWord((String[])args, (Iterable)Item.itemRegistry.getKeys());
        }
        return null;
    }
}

