/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.command;

import com.pahimar.ee3.command.CommandPlayerForgetCurrentItem;
import com.pahimar.ee3.command.CommandPlayerForgetEverything;
import com.pahimar.ee3.command.CommandPlayerForgetItem;
import com.pahimar.ee3.command.CommandPlayerLearnCurrentItem;
import com.pahimar.ee3.command.CommandPlayerLearnItem;
import com.pahimar.ee3.command.CommandRunTest;
import com.pahimar.ee3.command.CommandSetEnergyValue;
import com.pahimar.ee3.command.CommandSetEnergyValueCurrentItem;
import com.pahimar.ee3.command.CommandSetItemLearnable;
import com.pahimar.ee3.command.CommandSetItemNotLearnable;
import com.pahimar.ee3.command.CommandSetItemNotRecoverable;
import com.pahimar.ee3.command.CommandSetItemRecoverable;
import com.pahimar.ee3.command.CommandSyncEnergyValues;
import com.pahimar.ee3.command.CommandTemplateForgetCurrentItem;
import com.pahimar.ee3.command.CommandTemplateForgetEverything;
import com.pahimar.ee3.command.CommandTemplateForgetItem;
import com.pahimar.ee3.command.CommandTemplateLearnCurrentItem;
import com.pahimar.ee3.command.CommandTemplateLearnEverything;
import com.pahimar.ee3.command.CommandTemplateLearnItem;
import com.pahimar.ee3.reference.Names;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;

public class CommandEE
extends CommandBase {
    private static List<CommandBase> modCommands = new ArrayList<CommandBase>();
    private static List<String> commands = new ArrayList<String>();

    public String getCommandName() {
        return Names.Commands.BASE_COMMAND;
    }

    public String getCommandUsage(ICommandSender commandSender) {
        return "commands.ee3.usage";
    }

    public void processCommand(ICommandSender commandSender, String[] args) {
        if (args.length >= 1) {
            for (CommandBase command : modCommands) {
                if (!command.getCommandName().equalsIgnoreCase(args[0]) || !command.canCommandSenderUseCommand(commandSender)) continue;
                command.processCommand(commandSender, args);
            }
        }
    }

    public List addTabCompletionOptions(ICommandSender commandSender, String[] args) {
        if (args.length == 1) {
            return CommandEE.getListOfStringsFromIterableMatchingLastWord((String[])args, commands);
        }
        if (args.length >= 2) {
            for (CommandBase command : modCommands) {
                if (!command.getCommandName().equalsIgnoreCase(args[0])) continue;
                return command.addTabCompletionOptions(commandSender, args);
            }
        }
        return null;
    }

    static {
        modCommands.add(new CommandSetEnergyValue());
        modCommands.add(new CommandSetEnergyValueCurrentItem());
        modCommands.add(new CommandSyncEnergyValues());
        modCommands.add(new CommandPlayerLearnItem());
        modCommands.add(new CommandPlayerLearnCurrentItem());
        modCommands.add(new CommandPlayerForgetEverything());
        modCommands.add(new CommandPlayerForgetItem());
        modCommands.add(new CommandPlayerForgetCurrentItem());
        modCommands.add(new CommandTemplateLearnEverything());
        modCommands.add(new CommandTemplateLearnItem());
        modCommands.add(new CommandTemplateLearnCurrentItem());
        modCommands.add(new CommandTemplateForgetEverything());
        modCommands.add(new CommandTemplateForgetItem());
        modCommands.add(new CommandTemplateForgetCurrentItem());
        modCommands.add(new CommandSetItemLearnable());
        modCommands.add(new CommandSetItemNotLearnable());
        modCommands.add(new CommandSetItemRecoverable());
        modCommands.add(new CommandSetItemNotRecoverable());
        modCommands.add(new CommandRunTest());
        for (CommandBase commandBase : modCommands) {
            commands.add(commandBase.getCommandName());
        }
    }
}

