/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.client.util;

import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    private static int pulse = 0;
    private static boolean doInc = true;

    public static void renderItemIntoGUI(FontRenderer fontRenderer, ItemStack itemStack, int x, int y, float opacity, float scale, int zLevel) {
        IIcon icon = itemStack.getIconIndex();
        GL11.glDisable((int)2896);
        FMLClientHandler.instance().getClient().renderEngine.bindTexture(TextureMap.locationItemsTexture);
        int overlayColour = itemStack.getItem().getColorFromItemStack(itemStack, 0);
        float red = (float)(overlayColour >> 16 & 0xFF) / 255.0f;
        float green = (float)(overlayColour >> 8 & 0xFF) / 255.0f;
        float blue = (float)(overlayColour & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)opacity);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)x, (double)((float)y + 16.0f * scale), (double)zLevel, (double)icon.getMinU(), (double)icon.getMaxV());
        tessellator.addVertexWithUV((double)((float)x + 16.0f * scale), (double)((float)y + 16.0f * scale), (double)zLevel, (double)icon.getMaxU(), (double)icon.getMaxV());
        tessellator.addVertexWithUV((double)((float)x + 16.0f * scale), (double)y, (double)zLevel, (double)icon.getMaxU(), (double)icon.getMinV());
        tessellator.addVertexWithUV((double)x, (double)y, (double)zLevel, (double)icon.getMinU(), (double)icon.getMinV());
        tessellator.draw();
        GL11.glEnable((int)2896);
    }

    public static void renderQuad(ResourceLocation texture) {
        FMLClientHandler.instance().getClient().renderEngine.bindTexture(texture);
        Tessellator tessellator = Tessellator.instance;
        GL11.glEnable((int)32826);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-0.5, 0.5, 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV(0.5, 0.5, 0.0, 1.0, 1.0);
        tessellator.addVertexWithUV(0.5, -0.5, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV(-0.5, -0.5, 0.0, 0.0, 0.0);
        tessellator.draw();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)32826);
    }

    public static void renderPulsingQuad(ResourceLocation texture, float maxTransparency) {
        float pulseTransparency = (float)RenderUtils.getPulseValue() * maxTransparency / 3000.0f;
        FMLClientHandler.instance().getClient().renderEngine.bindTexture(texture);
        Tessellator tessellator = Tessellator.instance;
        GL11.glEnable((int)32826);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)pulseTransparency);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(1.0f, 1.0f, 1.0f, pulseTransparency);
        tessellator.addVertexWithUV(-0.5, 0.5, 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV(0.5, 0.5, 0.0, 1.0, 1.0);
        tessellator.addVertexWithUV(0.5, -0.5, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV(-0.5, -0.5, 0.0, 0.0, 0.0);
        tessellator.draw();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)32826);
    }

    private static int getPulseValue() {
        pulse = doInc ? (pulse += 50) : (pulse -= 50);
        if (pulse == 3000) {
            doInc = false;
        }
        if (pulse == 0) {
            doInc = true;
        }
        return pulse;
    }
}

