/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.client.renderer.tileentity;

import com.pahimar.ee3.client.renderer.model.ModelAludel;
import com.pahimar.ee3.reference.Textures;
import com.pahimar.ee3.tileentity.TileEntityAludel;
import com.pahimar.ee3.tileentity.TileEntityGlassBell;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityRendererAludel
extends TileEntitySpecialRenderer {
    private final ModelAludel modelAludel = new ModelAludel();
    private final RenderItem customRenderItem = new RenderItem(){

        public boolean shouldBob() {
            return false;
        }
    };

    public TileEntityRendererAludel() {
        this.customRenderItem.setRenderManager(RenderManager.instance);
    }

    public void renderTileEntityAt(TileEntity tileEntity, double x, double y, double z, float tick) {
        if (tileEntity instanceof TileEntityAludel) {
            TileEntityAludel tileEntityAludel = (TileEntityAludel)tileEntity;
            GL11.glPushMatrix();
            this.scaleTranslateRotate(x, y, z, tileEntityAludel.getOrientation());
            this.bindTexture(Textures.Model.ALUDEL);
            this.modelAludel.render();
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            TileEntity tileGlassBell = tileEntityAludel.getWorldObj().getTileEntity(tileEntityAludel.xCoord, tileEntityAludel.yCoord + 1, tileEntityAludel.zCoord);
            if (tileGlassBell instanceof TileEntityGlassBell && tileEntityAludel.outputItemStack != null) {
                float scaleFactor = this.getGhostItemScaleFactor(tileEntityAludel.outputItemStack);
                float rotationAngle = (float)(720.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
                EntityItem ghostEntityItem = new EntityItem(tileEntityAludel.getWorldObj());
                ghostEntityItem.hoverStart = 0.0f;
                ghostEntityItem.setEntityItemStack(tileEntityAludel.outputItemStack);
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.25f), (float)((float)z + 0.5f));
                GL11.glScalef((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
                GL11.glRotatef((float)rotationAngle, (float)0.0f, (float)1.0f, (float)0.0f);
                this.customRenderItem.doRender(ghostEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            }
            GL11.glPopMatrix();
        }
    }

    private void scaleTranslateRotate(double x, double y, double z, ForgeDirection orientation) {
        if (orientation == ForgeDirection.NORTH) {
            GL11.glTranslated((double)(x + 1.0), (double)y, (double)z);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (orientation == ForgeDirection.EAST) {
            GL11.glTranslated((double)(x + 1.0), (double)y, (double)(z + 1.0));
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (orientation == ForgeDirection.SOUTH) {
            GL11.glTranslated((double)x, (double)y, (double)(z + 1.0));
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (orientation == ForgeDirection.WEST) {
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    private float getGhostItemScaleFactor(ItemStack itemStack) {
        float scaleFactor = 1.0f;
        if (itemStack != null) {
            int numBlocks = 1;
            if (itemStack.stackSize > 1) {
                numBlocks = 2;
            } else if (itemStack.stackSize > 5) {
                numBlocks = 3;
            } else if (itemStack.stackSize > 20) {
                numBlocks = 4;
            } else if (itemStack.stackSize > 40) {
                numBlocks = 5;
            }
            if (itemStack.getItem() instanceof ItemBlock) {
                switch (numBlocks) {
                    case 1: {
                        return 0.9f;
                    }
                    case 2: {
                        return 0.9f;
                    }
                    case 3: {
                        return 0.9f;
                    }
                    case 4: {
                        return 0.9f;
                    }
                    case 5: {
                        return 0.8f;
                    }
                }
                return 0.9f;
            }
            switch (numBlocks) {
                case 1: {
                    return 0.65f;
                }
                case 2: {
                    return 0.65f;
                }
                case 3: {
                    return 0.65f;
                }
                case 4: {
                    return 0.65f;
                }
            }
            return 0.65f;
        }
        return scaleFactor;
    }
}

