/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.client.handler;

import com.pahimar.ee3.client.util.RenderUtils;
import com.pahimar.ee3.util.IOverlayItem;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class HUDTickHandler {
    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft minecraft = FMLClientHandler.instance().getClient();
            EntityClientPlayerMP entityPlayer = minecraft.thePlayer;
            if (entityPlayer != null) {
                ItemStack currentItemStack = entityPlayer.inventory.getCurrentItem();
                if (Minecraft.isGuiEnabled() && minecraft.inGameHasFocus && currentItemStack != null && currentItemStack.getItem() instanceof IOverlayItem) {
                    HUDTickHandler.renderHUDOverlayItem(minecraft, (EntityPlayer)entityPlayer, currentItemStack);
                }
            }
        }
    }

    private static void renderHUDOverlayItem(Minecraft minecraft, EntityPlayer entityPlayer, ItemStack itemStack) {
        float overlayScale = 2.0f;
        float overlayOpacity = 1.0f;
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(minecraft, minecraft.displayWidth, minecraft.displayHeight);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.getScaledWidth_double(), (double)sr.getScaledHeight_double(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glPushMatrix();
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        int hudOverlayX = 0;
        int hudOverlayY = 0;
        hudOverlayX = (int)((float)sr.getScaledWidth() - 16.0f * overlayScale);
        hudOverlayY = (int)((float)sr.getScaledHeight() - 16.0f * overlayScale);
        RenderUtils.renderItemIntoGUI(minecraft.fontRenderer, itemStack, hudOverlayX, hudOverlayY, overlayOpacity, overlayScale, -90);
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }
}

