/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.client.gui.inventory;

import com.pahimar.ee3.inventory.ContainerAlchemicalBag;
import com.pahimar.ee3.inventory.InventoryAlchemicalBag;
import com.pahimar.ee3.reference.Textures;
import com.pahimar.ee3.util.NBTHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiAlchemicalBag
extends GuiContainer {
    private final ItemStack parentItemStack;
    private final InventoryAlchemicalBag inventoryAlchemicalBag;

    public GuiAlchemicalBag(EntityPlayer entityPlayer, InventoryAlchemicalBag inventoryAlchemicalBag) {
        super((Container)new ContainerAlchemicalBag(entityPlayer, inventoryAlchemicalBag));
        this.parentItemStack = inventoryAlchemicalBag.parentItemStack;
        this.inventoryAlchemicalBag = inventoryAlchemicalBag;
        if (this.parentItemStack.getItemDamage() == 0) {
            this.xSize = 230;
            this.ySize = 186;
        } else if (this.parentItemStack.getItemDamage() == 1) {
            this.xSize = 230;
            this.ySize = 240;
        } else if (this.parentItemStack.getItemDamage() == 2) {
            this.xSize = 248;
            this.ySize = 256;
        }
    }

    protected void drawGuiContainerForegroundLayer(int x, int y) {
        if (this.parentItemStack.getItemDamage() == 0 || this.parentItemStack.getItemDamage() == 1) {
            this.fontRendererObj.drawString(StatCollector.translateToLocal((String)this.inventoryAlchemicalBag.getInventoryName()), 8, 6, Integer.parseInt("ffffff", 16));
            this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"container.inventory"), 35, this.ySize - 95 + 2, Integer.parseInt("ffffff", 16));
        }
    }

    protected void drawGuiContainerBackgroundLayer(float opacity, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.parentItemStack.getItemDamage() == 0) {
            this.mc.getTextureManager().bindTexture(Textures.Gui.ALCHEMICAL_BAG_SMALL);
        } else if (this.parentItemStack.getItemDamage() == 1) {
            this.mc.getTextureManager().bindTexture(Textures.Gui.ALCHEMICAL_BAG_MEDIUM);
        } else if (this.parentItemStack.getItemDamage() == 2) {
            this.mc.getTextureManager().bindTexture(Textures.Gui.ALCHEMICAL_BAG_LARGE);
        }
        int xStart = (this.width - this.xSize) / 2;
        int yStart = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(xStart, yStart, 0, 0, this.xSize, this.ySize);
    }

    public void onGuiClosed() {
        super.onGuiClosed();
        if (this.mc.thePlayer != null) {
            for (ItemStack itemStack : this.mc.thePlayer.inventory.mainInventory) {
                if (itemStack == null || !NBTHelper.hasTag(itemStack, "alchemicalBagGuiOpen")) continue;
                NBTHelper.removeTag(itemStack, "alchemicalBagGuiOpen");
            }
        }
    }
}

