/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.block;

import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.block.BlockAshInfusedStoneSlab;
import com.pahimar.ee3.block.BlockEE;
import com.pahimar.ee3.init.ModBlocks;
import com.pahimar.ee3.reference.GUIs;
import com.pahimar.ee3.reference.RenderIds;
import com.pahimar.ee3.tileentity.TileEntityTransmutationTablet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTransmutationTablet
extends BlockEE
implements ITileEntityProvider {
    public BlockTransmutationTablet() {
        super(Material.rock);
        this.setCreativeTab(null);
        this.setHardness(2.0f);
        this.setBlockName("transmutationTablet");
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iBlockAccess, int x, int y, int z) {
        if (this.isStructureValid(iBlockAccess, x, y, z)) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.625f, 1.0f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        }
    }

    public Item getItemDropped(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Item.getItemFromBlock((Block)ModBlocks.ashInfusedStoneSlab);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int sideHit, float hitX, float hitY, float hitZ) {
        if (entityPlayer.isSneaking()) {
            return false;
        }
        if (!world.isRemote && world.getTileEntity(x, y, z) instanceof TileEntityTransmutationTablet && this.isStructureValid((IBlockAccess)world, x, y, z)) {
            entityPlayer.openGui((Object)EquivalentExchange3.instance, GUIs.TRANSMUTATION_TABLET.ordinal(), world, x, y, z);
        }
        return true;
    }

    public int onBlockPlaced(World world, int x, int y, int z, int sideHit, float hitX, float hitY, float hitZ, int metaData) {
        return metaData;
    }

    public TileEntity createNewTileEntity(World world, int metaData) {
        return new TileEntityTransmutationTablet();
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getRenderType() {
        return RenderIds.tabletSlab;
    }

    private boolean isStructureValid(IBlockAccess iBlockAcces, int xCoord, int yCoord, int zCoord) {
        return iBlockAcces.getBlock(xCoord - 1, yCoord, zCoord - 1) instanceof BlockAshInfusedStoneSlab && iBlockAcces.getBlockMetadata(xCoord - 1, yCoord, zCoord - 1) == 1 && iBlockAcces.getBlock(xCoord, yCoord, zCoord - 1) instanceof BlockAshInfusedStoneSlab && iBlockAcces.getBlockMetadata(xCoord, yCoord, zCoord - 1) == 2 && iBlockAcces.getBlock(xCoord + 1, yCoord, zCoord - 1) instanceof BlockAshInfusedStoneSlab && iBlockAcces.getBlockMetadata(xCoord + 1, yCoord, zCoord - 1) == 3 && iBlockAcces.getBlock(xCoord - 1, yCoord, zCoord) instanceof BlockAshInfusedStoneSlab && iBlockAcces.getBlockMetadata(xCoord - 1, yCoord, zCoord) == 4 && iBlockAcces.getBlock(xCoord + 1, yCoord, zCoord) instanceof BlockAshInfusedStoneSlab && iBlockAcces.getBlockMetadata(xCoord + 1, yCoord, zCoord) == 5 && iBlockAcces.getBlock(xCoord - 1, yCoord, zCoord + 1) instanceof BlockAshInfusedStoneSlab && iBlockAcces.getBlockMetadata(xCoord - 1, yCoord, zCoord + 1) == 6 && iBlockAcces.getBlock(xCoord, yCoord, zCoord + 1) instanceof BlockAshInfusedStoneSlab && iBlockAcces.getBlockMetadata(xCoord, yCoord, zCoord + 1) == 7 && iBlockAcces.getBlock(xCoord + 1, yCoord, zCoord + 1) instanceof BlockAshInfusedStoneSlab && iBlockAcces.getBlockMetadata(xCoord + 1, yCoord, zCoord + 1) == 8;
    }
}

