/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.block;

import com.pahimar.ee3.creativetab.CreativeTab;
import com.pahimar.ee3.init.ModBlocks;
import com.pahimar.ee3.reference.Textures;
import com.pahimar.ee3.tileentity.TileEntityTransmutationTablet;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockAshInfusedStoneSlab
extends BlockSlab {
    @SideOnly(value=Side.CLIENT)
    protected IIcon blockIcon;
    @SideOnly(value=Side.CLIENT)
    protected IIcon sideVariant1;
    @SideOnly(value=Side.CLIENT)
    protected IIcon sideVariant2;
    @SideOnly(value=Side.CLIENT)
    protected IIcon topVariant1;
    @SideOnly(value=Side.CLIENT)
    protected IIcon topVariant2;
    @SideOnly(value=Side.CLIENT)
    protected IIcon topVariant3;
    @SideOnly(value=Side.CLIENT)
    protected IIcon topVariant4;

    public BlockAshInfusedStoneSlab() {
        super(false, Material.rock);
        this.setCreativeTab(CreativeTab.EE3_TAB);
        this.setHardness(2.0f);
        this.setBlockName("ashInfusedStoneSlab");
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iBlockAccess, int x, int y, int z) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        if (this.isAssociatedWithValidTablet(world, x, y, z)) {
            int metaData = world.getBlockMetadata(x, y, z);
            if (metaData == 1) {
                this.setBlockBounds(0.5f, 0.0f, 0.5f, 1.0f, 0.625f, 1.0f);
                super.addCollisionBoxesToList(world, x, y, z, axisAlignedBB, list, entity);
            } else if (metaData == 2) {
                this.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 0.625f, 1.0f);
                super.addCollisionBoxesToList(world, x, y, z, axisAlignedBB, list, entity);
            } else if (metaData == 3) {
                this.setBlockBounds(0.0f, 0.0f, 1.0f, 0.5f, 0.625f, 0.5f);
                super.addCollisionBoxesToList(world, x, y, z, axisAlignedBB, list, entity);
            } else if (metaData == 4) {
                this.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 0.625f, 1.0f);
                super.addCollisionBoxesToList(world, x, y, z, axisAlignedBB, list, entity);
            } else if (metaData == 5) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 0.625f, 1.0f);
                super.addCollisionBoxesToList(world, x, y, z, axisAlignedBB, list, entity);
            } else if (metaData == 6) {
                this.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 0.625f, 0.5f);
                super.addCollisionBoxesToList(world, x, y, z, axisAlignedBB, list, entity);
            } else if (metaData == 7) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.625f, 0.5f);
                super.addCollisionBoxesToList(world, x, y, z, axisAlignedBB, list, entity);
            } else if (metaData == 8) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 0.625f, 0.5f);
                super.addCollisionBoxesToList(world, x, y, z, axisAlignedBB, list, entity);
            }
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        super.addCollisionBoxesToList(world, x, y, z, axisAlignedBB, list, entity);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int sideHit, float hitX, float hitY, float hitZ) {
        int metaData = world.getBlockMetadata(x, y, z);
        int shiftedX = x;
        int shiftedZ = z;
        if (metaData != 0) {
            if (metaData == 1) {
                ++shiftedX;
                ++shiftedZ;
            } else if (metaData == 2) {
                ++shiftedZ;
            } else if (metaData == 3) {
                --shiftedX;
                ++shiftedZ;
            } else if (metaData == 4) {
                ++shiftedX;
            } else if (metaData == 5) {
                --shiftedX;
            } else if (metaData == 6) {
                ++shiftedX;
                --shiftedZ;
            } else if (metaData == 7) {
                --shiftedZ;
            } else if (metaData == 8) {
                --shiftedX;
                --shiftedZ;
            }
            if (world.getTileEntity(shiftedX, y, shiftedZ) instanceof TileEntityTransmutationTablet) {
                world.getBlock(shiftedX, y, shiftedZ).onBlockActivated(world, shiftedX, y, shiftedZ, entityPlayer, sideHit, hitX, hitY, hitZ);
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.blockIcon = iconRegister.registerIcon(String.format("%s", this.getUnwrappedUnlocalizedName(this.getUnlocalizedName())));
        this.sideVariant1 = iconRegister.registerIcon(String.format("%s", this.getUnwrappedUnlocalizedName(this.getUnlocalizedName()) + "_side1"));
        this.sideVariant2 = iconRegister.registerIcon(String.format("%s", this.getUnwrappedUnlocalizedName(this.getUnlocalizedName()) + "_side2"));
        this.topVariant1 = iconRegister.registerIcon(String.format("%s", this.getUnwrappedUnlocalizedName(this.getUnlocalizedName()) + "_top1"));
        this.topVariant2 = iconRegister.registerIcon(String.format("%s", this.getUnwrappedUnlocalizedName(this.getUnlocalizedName()) + "_top2"));
        this.topVariant3 = iconRegister.registerIcon(String.format("%s", this.getUnwrappedUnlocalizedName(this.getUnlocalizedName()) + "_top3"));
        this.topVariant4 = iconRegister.registerIcon(String.format("%s", this.getUnwrappedUnlocalizedName(this.getUnlocalizedName()) + "_top4"));
    }

    public String getUnlocalizedName() {
        return String.format("tile.%s%s", Textures.RESOURCE_PREFIX, this.getUnwrappedUnlocalizedName(super.getUnlocalizedName()));
    }

    protected String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)side);
        if (forgeDirection == ForgeDirection.SOUTH || forgeDirection == ForgeDirection.NORTH || forgeDirection == ForgeDirection.EAST || forgeDirection == ForgeDirection.WEST) {
            if (meta == 1 || meta == 3 || meta == 6 || meta == 8) {
                return this.sideVariant1;
            }
            return this.sideVariant2;
        }
        if (forgeDirection == ForgeDirection.UP) {
            if (meta == 1) {
                return this.topVariant1;
            }
            if (meta == 3) {
                return this.topVariant4;
            }
            if (meta == 6) {
                return this.topVariant2;
            }
            if (meta == 8) {
                return this.topVariant3;
            }
        }
        return this.blockIcon;
    }

    public String func_150002_b(int meta) {
        return this.getUnlocalizedName();
    }

    private boolean isAssociatedWithValidTablet(World world, int x, int y, int z) {
        int metaData = world.getBlockMetadata(x, y, z);
        if (metaData != 0) {
            int shiftedX = x;
            int shiftedZ = z;
            if (metaData == 1) {
                ++shiftedX;
                ++shiftedZ;
            } else if (metaData == 2) {
                ++shiftedZ;
            } else if (metaData == 3) {
                --shiftedX;
                ++shiftedZ;
            } else if (metaData == 4) {
                ++shiftedX;
            } else if (metaData == 5) {
                --shiftedZ;
            } else if (metaData == 6) {
                ++shiftedX;
                --shiftedZ;
            } else if (metaData == 7) {
                --shiftedZ;
            } else if (metaData == 8) {
                --shiftedX;
                --shiftedZ;
            }
            if (world.getTileEntity(shiftedX, y, shiftedZ) instanceof TileEntityTransmutationTablet) {
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Item getItem(World world, int x, int y, int z) {
        return Item.getItemFromBlock((Block)ModBlocks.ashInfusedStoneSlab);
    }

    public int getDamageValue(World world, int x, int y, int z) {
        return 0;
    }
}

