/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.block;

import com.pahimar.ee3.api.array.AlchemyArray;
import com.pahimar.ee3.array.AlchemyArrayRegistry;
import com.pahimar.ee3.block.BlockEE;
import com.pahimar.ee3.reference.RenderIds;
import com.pahimar.ee3.reference.Sounds;
import com.pahimar.ee3.settings.ChalkSettings;
import com.pahimar.ee3.tileentity.TileEntityAlchemyArray;
import com.pahimar.ee3.tileentity.TileEntityEE;
import com.pahimar.ee3.util.CommonSoundHelper;
import com.pahimar.ee3.util.EntityHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockAlchemyArray
extends BlockEE
implements ITileEntityProvider {
    public BlockAlchemyArray() {
        super(Material.circuits);
        this.setCreativeTab(null);
        this.setBlockName("alchemyArray");
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getRenderType() {
        return RenderIds.alchemyArray;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (world.getTileEntity(x, y, z) instanceof TileEntityAlchemyArray) {
            TileEntityAlchemyArray tileEntityAlchemyArray = (TileEntityAlchemyArray)world.getTileEntity(x, y, z);
            return tileEntityAlchemyArray.getLightLevel();
        }
        return 0;
    }

    public Item getItemDropped(int par1, Random random, int par2) {
        return null;
    }

    public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        if (world.getTileEntity(x, y, z) instanceof TileEntityAlchemyArray) {
            TileEntityAlchemyArray tileEntityAlchemyArray = (TileEntityAlchemyArray)world.getTileEntity(x, y, z);
            switch (tileEntityAlchemyArray.getOrientation()) {
                case DOWN: {
                    this.setBlockBounds(0.0f, 1.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
                    break;
                }
                case UP: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
                    break;
                }
                case NORTH: {
                    this.setBlockBounds(0.0f, 0.0f, 0.9375f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case SOUTH: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0625f);
                    break;
                }
                case EAST: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.0625f, 1.0f, 1.0f);
                    break;
                }
                case WEST: {
                    this.setBlockBounds(1.0f, 0.0f, 0.0f, 0.9375f, 1.0f, 1.0f);
                    break;
                }
            }
        }
        return super.collisionRayTrace(world, x, y, z, startVec, endVec);
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return world.getBlock(x, y, z).isReplaceable((IBlockAccess)world, x, y, z) && (world.isSideSolid(x - 1, y, z, ForgeDirection.EAST) || world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) || world.isSideSolid(x, y - 1, z, ForgeDirection.UP) || world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN));
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, int sideHit) {
        ForgeDirection side = ForgeDirection.getOrientation((int)sideHit);
        return world.getBlock(x, y, z).isReplaceable((IBlockAccess)world, x, y, z) && (side == ForgeDirection.DOWN && world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN) || side == ForgeDirection.UP && world.isSideSolid(x, y - 1, z, ForgeDirection.UP) || side == ForgeDirection.NORTH && world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) || side == ForgeDirection.SOUTH && world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || side == ForgeDirection.WEST && world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || side == ForgeDirection.EAST && world.isSideSolid(x - 1, y, z, ForgeDirection.EAST));
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        if (!world.isRemote && world.getTileEntity(x, y, z) instanceof TileEntityAlchemyArray) {
            TileEntityAlchemyArray tileEntityAlchemyArray = (TileEntityAlchemyArray)world.getTileEntity(x, y, z);
            boolean invalidateAlchemyArray = false;
            if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.UP && !world.isSideSolid(x, y - 1, z, ForgeDirection.UP, true)) {
                invalidateAlchemyArray = true;
            } else if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.DOWN && !world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN, true)) {
                invalidateAlchemyArray = true;
            } else if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.NORTH && !world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH, true)) {
                invalidateAlchemyArray = true;
            } else if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.SOUTH && !world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH, true)) {
                invalidateAlchemyArray = true;
            } else if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.EAST && !world.isSideSolid(x - 1, y, z, ForgeDirection.EAST, true)) {
                invalidateAlchemyArray = true;
            } else if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.WEST && !world.isSideSolid(x + 1, y, z, ForgeDirection.WEST, true)) {
                invalidateAlchemyArray = true;
            }
            if (invalidateAlchemyArray) {
                tileEntityAlchemyArray.invalidate();
                world.setBlockToAir(x, y, z);
            }
        }
    }

    public int onBlockPlaced(World world, int x, int y, int z, int sideHit, float hitX, float hitY, float hitZ, int metaData) {
        return sideHit;
    }

    @Override
    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        if (!world.isRemote && world.getTileEntity(x, y, z) instanceof TileEntityAlchemyArray && entityLiving instanceof EntityPlayer) {
            NBTTagCompound customEntityData = EntityHelper.getCustomEntityData((Entity)entityLiving);
            ChalkSettings chalkSettings = new ChalkSettings();
            chalkSettings.readFromNBT(customEntityData);
            AlchemyArray alchemyArray = AlchemyArrayRegistry.getInstance().getAlchemyArray(chalkSettings.getIndex());
            if (alchemyArray != null) {
                int facing = MathHelper.floor_double((double)((double)(entityLiving.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
                world.setBlockMetadataWithNotify(x, y, z, world.getBlockMetadata(x, y, z), 3);
                ((TileEntityEE)world.getTileEntity(x, y, z)).setOrientation(world.getBlockMetadata(x, y, z));
                ((TileEntityAlchemyArray)world.getTileEntity(x, y, z)).setRotation(chalkSettings.getRotation(), facing);
                ((TileEntityAlchemyArray)world.getTileEntity(x, y, z)).setAlchemyArray(alchemyArray, chalkSettings.getSize());
                CommonSoundHelper.playSoundAtPlayer((EntityPlayer)entityLiving, Sounds.Chalk.getRandomChalkSound(), 1.0f, 1.0f);
                ((TileEntityAlchemyArray)world.getTileEntity(x, y, z)).onBlockPlacedBy(world, x, y, z, entityLiving, itemStack);
            }
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int sideHit, float hitX, float hitY, float hitZ) {
        if (world.getTileEntity(x, y, z) instanceof TileEntityAlchemyArray) {
            ((TileEntityAlchemyArray)world.getTileEntity(x, y, z)).onBlockActivated(world, x, y, z, entityPlayer, sideHit, hitX, hitY, hitZ);
        }
        return false;
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        if (world.getTileEntity(x, y, z) instanceof TileEntityAlchemyArray) {
            ((TileEntityAlchemyArray)world.getTileEntity(x, y, z)).onBlockClicked(world, x, y, z, entityPlayer);
        }
    }

    public void onBlockDestroyedByExplosion(World world, int x, int y, int z, Explosion explosion) {
        if (world.getTileEntity(x, y, z) instanceof TileEntityAlchemyArray) {
            ((TileEntityAlchemyArray)world.getTileEntity(x, y, z)).onBlockDestroyedByExplosion(world, x, y, z, explosion);
        }
    }

    public void onBlockDestroyedByPlayer(World world, int x, int y, int z, int metaData) {
        if (world.getTileEntity(x, y, z) instanceof TileEntityAlchemyArray) {
            ((TileEntityAlchemyArray)world.getTileEntity(x, y, z)).onBlockDestroyedByPlayer(world, x, y, z, metaData);
        }
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (world.getTileEntity(x, y, z) instanceof TileEntityAlchemyArray) {
            ((TileEntityAlchemyArray)world.getTileEntity(x, y, z)).onEntityCollidedWithBlock(world, x, y, z, entity);
        }
    }

    public void onFallenUpon(World world, int x, int y, int z, Entity entity, float fallDistance) {
        if (world.getTileEntity(x, y, z) instanceof TileEntityAlchemyArray) {
            ((TileEntityAlchemyArray)world.getTileEntity(x, y, z)).onFallenUpon(world, x, y, z, entity, fallDistance);
        }
    }

    public TileEntity createNewTileEntity(World world, int metaData) {
        return new TileEntityAlchemyArray();
    }
}

