/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import baubles.api.BaublesApi;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.Log;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class BaublesUtil {
    private static final BaublesUtil instance = new BaublesUtil();
    private static final boolean baublesLoaded = Loader.isModLoaded((String)"Baubles");
    private static boolean failedDirectAccess = false;

    private BaublesUtil() {
    }

    public static BaublesUtil instance() {
        return instance;
    }

    public boolean hasBaubles() {
        return baublesLoaded;
    }

    public IInventory getBaubles(EntityPlayer player) {
        return this.hasBaubles() ? this.getBaublesInvUnsafe(player) : null;
    }

    private IInventory getBaublesInvUnsafe(EntityPlayer player) {
        return BaublesApi.getBaubles((EntityPlayer)player);
    }

    public void disableCallbacks(IInventory baubles, boolean b) {
        if (!failedDirectAccess) {
            try {
                Class<?> inventoryBaubles = Class.forName("baubles.common.container.InventoryBaubles");
                Field blockEvents = inventoryBaubles.getDeclaredField("blockEvents");
                blockEvents.set(baubles, b);
            }
            catch (Throwable t) {
                Log.info("Failed to access Baubles internals: " + t);
                failedDirectAccess = true;
            }
        }
    }

    public static enum WhoAmI {
        SPCLIENT,
        MPCLIENT,
        SPSERVER,
        MPSERVER,
        OTHER;


        public static WhoAmI whoAmI(World world) {
            Side side = FMLCommonHandler.instance().getSide();
            if (side == Side.CLIENT) {
                if (Minecraft.getMinecraft().isIntegratedServerRunning()) {
                    if (world.isRemote) {
                        return SPCLIENT;
                    }
                    return SPSERVER;
                }
                return MPCLIENT;
            }
            if (side == Side.SERVER) {
                if (MinecraftServer.getServer().isDedicatedServer()) {
                    return MPSERVER;
                }
                if (Minecraft.getMinecraft().isIntegratedServerRunning()) {
                    return SPSERVER;
                }
            }
            return OTHER;
        }
    }
}

