/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.client.render.TechneUtil;
import com.google.common.collect.Lists;
import crazypants.enderio.EnderIO;
import crazypants.enderio.teleport.TravelController;
import crazypants.enderio.teleport.anchor.TravelEntitySpecialRenderer;
import crazypants.enderio.teleport.telepad.TelePadRenderer;
import crazypants.enderio.teleport.telepad.TileTelePad;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.obj.GroupObject;
import org.lwjgl.opengl.GL11;

public class TelePadSpecialRenderer
extends TravelEntitySpecialRenderer {
    private final Map<String, GroupObject> fullModel;
    private final GroupObject blade1;
    private final GroupObject blade2;
    private final GroupObject blade3;
    private final List<GroupObject> blades;
    private final GroupObject glass;
    private static Random rand = new Random();

    public TelePadSpecialRenderer(TelePadRenderer telePadRenderer) {
        this.fullModel = telePadRenderer.getFullModel();
        this.blade1 = this.fullModel.get("blade1");
        this.blade2 = this.fullModel.get("blade2");
        this.blade3 = this.fullModel.get("blade3");
        this.blades = Lists.newArrayList((Object[])new GroupObject[]{this.blade3, this.blade2, this.blade1});
        this.glass = this.fullModel.get("glass");
    }

    @Override
    public void renderTileEntityAt(TileEntity te, double x, double y, double z, float p_147500_8_) {
        TileTelePad tp = (TileTelePad)te;
        if (tp.isMaster() && tp.inNetwork()) {
            TravelController.instance.addCandidate(tp.getLocation());
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.01), (double)(z + 0.5));
            Tessellator tes = Tessellator.instance;
            tes.setBrightness(0xF000F0);
            GL11.glDepthMask((boolean)true);
            rand.setSeed(te.xCoord + te.yCoord + te.zCoord);
            for (int i = 0; i < 3; ++i) {
                GL11.glPushMatrix();
                GL11.glRotatef((float)(tp.bladeRots[i] + (float)rand.nextInt(360) + tp.spinSpeed * p_147500_8_ * (float)(i + 20)), (float)0.0f, (float)1.0f, (float)0.0f);
                this.render(this.blades.get(i), te, tes);
                GL11.glPopMatrix();
            }
            GL11.glEnable((int)3042);
            this.render(this.glass, te, tes);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
        super.renderTileEntityAt(te, x, y, z, p_147500_8_);
    }

    @Override
    protected void renderBlock(IBlockAccess world, double sf) {
        Tessellator.instance.setColorRGBA_F(1.0f, 1.0f, 1.0f, 0.75f);
        CubeRenderer.render((BoundingBox)BoundingBox.UNIT_CUBE.scale(sf, sf, sf), (IIcon)EnderIO.blockTelePad.getHighlightIcon());
    }

    @Override
    public IIcon getSelectedIcon() {
        return IconUtil.whiteTexture;
    }

    @Override
    public IIcon getHighlightIcon() {
        return IconUtil.whiteTexture;
    }

    private void render(GroupObject model, TileEntity te, Tessellator tes) {
        IIcon icon = te.getBlockType().getIcon((IBlockAccess)te.getWorldObj(), te.xCoord, te.yCoord, te.zCoord, 0);
        if (icon != null && model != null) {
            tes.startDrawingQuads();
            TechneUtil.renderWithIcon((GroupObject)model, (IIcon)icon, null, (Tessellator)Tessellator.instance, (IBlockAccess)te.getWorldObj(), (int)0, (int)0, (int)0, null, (boolean)false);
            tes.draw();
        }
    }
}

