/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.TechneModelRenderer;
import com.enderio.core.client.render.TechneUtil;
import com.enderio.core.common.util.BlockCoord;
import com.google.common.collect.Lists;
import crazypants.enderio.EnderIO;
import crazypants.enderio.teleport.telepad.BlockTelePad;
import crazypants.enderio.teleport.telepad.TileTelePad;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.common.util.ForgeDirection;

public class TelePadRenderer
extends TechneModelRenderer {
    private final Collection<GroupObject> strippedModel = Lists.newArrayList();

    public TelePadRenderer() {
        super(TechneUtil.getModel((String)EnderIO.DOMAIN, (String)"models/telePad"), BlockTelePad.renderId);
        for (String s : this.model.keySet()) {
            if (s.equals("glass") || s.contains("blade")) continue;
            this.strippedModel.add((GroupObject)this.model.get(s));
        }
    }

    protected Collection<GroupObject> getModel() {
        return this.strippedModel;
    }

    protected Collection<GroupObject> getModel(Block block, int metadata) {
        return this.getModel();
    }

    protected Collection<GroupObject> getModel(IBlockAccess world, int x, int y, int z) {
        return this.getModel();
    }

    Map<String, GroupObject> getFullModel() {
        return this.model;
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileTelePad te = (TileTelePad)world.getTileEntity(x, y, z);
        boolean ret = true;
        if (te.inNetwork()) {
            if (renderer.hasOverrideBlockTexture()) {
                IIcon icon = renderer.overrideBlockTexture;
                renderer.renderFaceYNeg(block, (double)x, (double)y, (double)z, icon);
                renderer.renderFaceYPos(block, (double)x, (double)y, (double)z, icon);
                BlockCoord bc = te.getLocation();
                if (!this.isTelepad(world, bc, ForgeDirection.EAST)) {
                    renderer.renderFaceXPos(block, (double)x, (double)y, (double)z, icon);
                }
                if (!this.isTelepad(world, bc, ForgeDirection.WEST)) {
                    renderer.renderFaceXNeg(block, (double)x, (double)y, (double)z, icon);
                }
                if (!this.isTelepad(world, bc, ForgeDirection.SOUTH)) {
                    renderer.renderFaceZPos(block, (double)x, (double)y, (double)z, icon);
                }
                if (!this.isTelepad(world, bc, ForgeDirection.NORTH)) {
                    renderer.renderFaceZNeg(block, (double)x, (double)y, (double)z, icon);
                }
            } else if (te.isMaster()) {
                super.renderWorldBlock(world, x, y, z, block, modelId, renderer);
            } else {
                ret = false;
            }
        } else {
            renderer.renderStandardBlock(block, x, y, z);
        }
        return ret;
    }

    private boolean isTelepad(IBlockAccess world, BlockCoord pos, ForgeDirection dir) {
        return pos.getLocation(dir).getTileEntity(world) instanceof TileTelePad;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        Tessellator.instance.startDrawingQuads();
        CubeRenderer.render((Block)block, (int)metadata);
        Tessellator.instance.draw();
    }
}

