/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.common.network.MessageTileEntity;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.EnderIO;
import crazypants.enderio.teleport.telepad.TileTelePad;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketTeleport
extends MessageTileEntity<TileTelePad>
implements IMessageHandler<PacketTeleport, IMessage> {
    private int entityId;
    private Type type;
    private boolean wasBlocked;

    public PacketTeleport() {
    }

    public PacketTeleport(Type type, TileTelePad te, int entityId) {
        super((TileEntity)te);
        this.entityId = entityId;
        this.type = type;
    }

    public PacketTeleport(Type type, TileTelePad te, boolean wasBlocked) {
        super((TileEntity)te);
        this.wasBlocked = wasBlocked;
        this.type = type;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.entityId);
        buf.writeInt(this.type.ordinal());
        buf.writeBoolean(this.wasBlocked);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.entityId = buf.readInt();
        this.type = Type.values()[buf.readInt()];
        this.wasBlocked = buf.readBoolean();
    }

    public IMessage onMessage(PacketTeleport message, MessageContext ctx) {
        World world = ctx.side.isClient() ? EnderIO.proxy.getClientWorld() : message.getWorld(ctx);
        TileEntity te = message.getTileEntity(world);
        if (te instanceof TileTelePad) {
            Entity e = world.getEntityByID(message.entityId);
            switch (message.type) {
                case BEGIN: {
                    ((TileTelePad)te).enqueueTeleport(e, false);
                    break;
                }
                case END: {
                    ((TileTelePad)te).dequeueTeleport(e, false);
                    break;
                }
                case TELEPORT: {
                    ((TileTelePad)te).wasBlocked = message.wasBlocked;
                }
            }
        }
        return null;
    }

    static enum Type {
        BEGIN,
        END,
        TELEPORT;

    }
}

