/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.ITelePad;
import crazypants.enderio.teleport.anchor.BlockTravelAnchor;
import crazypants.enderio.teleport.telepad.TileTelePad;
import java.util.List;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C08PacketPlayerBlockPlacement;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemCoordSelector
extends Item
implements IResourceTooltipProvider {
    public static ItemCoordSelector create() {
        ItemCoordSelector ret = new ItemCoordSelector();
        GameRegistry.registerItem((Item)ret, (String)ModObject.itemCoordSelector.unlocalisedName);
        return ret;
    }

    private ItemCoordSelector() {
        this.setCreativeTab(EnderIOTab.tabEnderIO);
        this.setUnlocalizedName(ModObject.itemCoordSelector.unlocalisedName);
        this.setTextureName("EnderIO:" + ModObject.itemCoordSelector.unlocalisedName);
        this.setMaxStackSize(1);
    }

    public void getSubItems(Item item, CreativeTabs p_150895_2_, List list) {
        ItemStack stack = new ItemStack(item);
        ItemCoordSelector.init(stack);
        list.add(stack);
    }

    public static void init(ItemStack stack) {
        stack.stackTagCompound = new NBTTagCompound();
        new BlockCoord().writeToNBT(stack.stackTagCompound);
        stack.stackTagCompound.setBoolean("default", true);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean p_77624_4_) {
        if (!stack.stackTagCompound.getBoolean("default")) {
            list.add(this.getCoords(stack).chatString(EnumChatFormatting.GRAY));
        }
        super.addInformation(stack, player, list, p_77624_4_);
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (this.rayTraceCoords(stack, world, player)) {
            player.swingItem();
        }
        return super.onItemRightClick(stack, world, player);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!this.rayTraceCoords(stack, world, player)) {
            return false;
        }
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof ITelePad) {
            ITelePad tp = (ITelePad)te;
            TileTelePad tile = null;
            if (te instanceof TileTelePad) {
                tile = (TileTelePad)te;
            }
            if (tp.canBlockBeAccessed(player)) {
                BlockCoord bc = this.getCoords(stack);
                BlockCoord cur = new BlockCoord(tp.getX(), tp.getY(), tp.getZ());
                int dim = this.getDimension(stack);
                int curDim = tp.getTargetDim();
                if (!bc.equals((Object)cur)) {
                    if (tile != null) {
                        tile.setCoords_internal(bc);
                    } else {
                        tp.setCoords(bc);
                    }
                    if (!world.isRemote) {
                        player.addChatMessage((IChatComponent)new ChatComponentText(EnderIO.lang.localize("itemCoordSelector.chat.setCoords", new Object[]{bc.chatString()})));
                    }
                }
                if (dim != curDim) {
                    if (tile != null) {
                        tile.setTargetDim_internal(dim);
                    } else {
                        tp.setTargetDim(dim);
                    }
                    if (!world.isRemote) {
                        player.addChatMessage((IChatComponent)new ChatComponentText(EnderIO.lang.localize("itemCoordSelector.chat.setDimension", new Object[]{EnumChatFormatting.GREEN.toString(), Integer.toString(dim)})));
                    }
                }
                if (bc.equals((Object)cur) && dim == curDim) {
                    return false;
                }
            } else {
                BlockTravelAnchor.sendPrivateChatMessage(player, tp.getOwner());
            }
        }
        if (world.isRemote) {
            this.sendItemUsePacket(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
        }
        return true;
    }

    private boolean rayTraceCoords(ItemStack stack, World world, EntityPlayer player) {
        Vector3d headVec = Util.getEyePositionEio((EntityPlayer)player);
        Vec3 start = headVec.getVec3();
        Vec3 lookVec = player.getLook(1.0f);
        double reach = 500.0;
        headVec.add(lookVec.xCoord * reach, lookVec.yCoord * reach, lookVec.zCoord * reach);
        MovingObjectPosition mop = world.rayTraceBlocks(start, headVec.getVec3());
        if (mop == null) {
            return false;
        }
        BlockCoord bc = new BlockCoord(mop);
        BlockCoord onStack = this.getCoords(stack);
        TileEntity te = bc.getTileEntity((IBlockAccess)world);
        if (te instanceof ITelePad) {
            return true;
        }
        if (!player.isSneaking()) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[mop.sideHit];
            bc = bc.getLocation(dir);
        }
        int dim = world.provider.dimensionId;
        int curDim = this.getDimension(stack);
        boolean changed = false;
        if (!bc.equals((Object)onStack)) {
            this.setCoords(stack, bc);
            this.onCoordsChanged(player, bc);
            changed = true;
        }
        if (dim != curDim) {
            this.setDimension(stack, world);
            this.onDimensionChanged(player, this.getDimension(stack));
            changed = true;
        }
        return changed;
    }

    private void sendItemUsePacket(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        NetHandlerPlayClient netClientHandler = (NetHandlerPlayClient)FMLClientHandler.instance().getClientPlayHandler();
        netClientHandler.addToSendQueue((Packet)new C08PacketPlayerBlockPlacement(x, y, z, side, player.inventory.getCurrentItem(), hitX, hitY, hitZ));
    }

    private void onCoordsChanged(EntityPlayer player, BlockCoord bc) {
        if (!player.worldObj.isRemote) {
            player.addChatMessage((IChatComponent)new ChatComponentText(EnderIO.lang.localize("itemCoordSelector.chat.newCoords", new Object[]{bc.chatString()})));
        }
    }

    private void onDimensionChanged(EntityPlayer player, int dim) {
        if (!player.worldObj.isRemote) {
            player.addChatMessage((IChatComponent)new ChatComponentText(EnderIO.lang.localize("itemCoordSelector.chat.newDimension", new Object[]{EnumChatFormatting.GREEN.toString(), Integer.toString(dim)})));
        }
    }

    public void setCoords(ItemStack stack, BlockCoord bc) {
        stack.stackTagCompound.setBoolean("default", false);
        bc.writeToNBT(stack.stackTagCompound);
    }

    public void setDimension(ItemStack stack, World world) {
        stack.stackTagCompound.setInteger("dimension", world.provider.dimensionId);
    }

    public BlockCoord getCoords(ItemStack stack) {
        return BlockCoord.readFromNBT((NBTTagCompound)stack.stackTagCompound);
    }

    public int getDimension(ItemStack stack) {
        return stack.stackTagCompound.getInteger("dimension");
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.getUnlocalizedName();
    }
}

