/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.packet;

import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.TeleportEntityEvent;
import crazypants.enderio.api.teleport.TravelSource;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraftforge.common.MinecraftForge;

public class PacketTravelEvent
implements IMessage,
IMessageHandler<PacketTravelEvent, IMessage> {
    int x;
    int y;
    int z;
    int powerUse;
    boolean conserveMotion;
    int entityId;
    int source;

    public PacketTravelEvent() {
    }

    public PacketTravelEvent(Entity entity, int x, int y, int z, int powerUse, boolean conserveMotion, TravelSource source) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.powerUse = powerUse;
        this.conserveMotion = conserveMotion;
        this.entityId = entity instanceof EntityPlayer ? -1 : entity.getEntityId();
        this.source = source.ordinal();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.powerUse);
        buf.writeBoolean(this.conserveMotion);
        buf.writeInt(this.entityId);
        buf.writeInt(this.source);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.powerUse = buf.readInt();
        this.conserveMotion = buf.readBoolean();
        this.entityId = buf.readInt();
        this.source = buf.readInt();
    }

    public IMessage onMessage(PacketTravelEvent message, MessageContext ctx) {
        EntityPlayerMP toTp = message.entityId == -1 ? ctx.getServerHandler().playerEntity : ctx.getServerHandler().playerEntity.worldObj.getEntityByID(message.entityId);
        int x = message.x;
        int y = message.y;
        int z = message.z;
        TravelSource source = TravelSource.values()[message.source];
        PacketTravelEvent.doServerTeleport((Entity)toTp, x, y, z, message.powerUse, message.conserveMotion, source);
        return null;
    }

    public static boolean doServerTeleport(Entity toTp, int x, int y, int z, int powerUse, boolean conserveMotion, TravelSource source) {
        EntityPlayer player = toTp instanceof EntityPlayer ? (EntityPlayer)toTp : null;
        TeleportEntityEvent evt = new TeleportEntityEvent(toTp, source, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
            return false;
        }
        x = evt.targetX;
        y = evt.targetY;
        z = evt.targetZ;
        toTp.worldObj.playSoundEffect(toTp.posX, toTp.posY, toTp.posZ, source.sound, 1.0f, 1.0f);
        toTp.playSound(source.sound, 1.0f, 1.0f);
        if (player != null) {
            player.setPositionAndUpdate((double)x + 0.5, (double)y + 1.1, (double)z + 0.5);
        } else {
            toTp.setPosition((double)x, (double)y, (double)z);
        }
        toTp.worldObj.playSoundEffect((double)x, (double)y, (double)z, source.sound, 1.0f, 1.0f);
        toTp.fallDistance = 0.0f;
        if (player != null) {
            if (conserveMotion) {
                Vector3d velocityVex = Util.getLookVecEio((EntityPlayer)player);
                S12PacketEntityVelocity p = new S12PacketEntityVelocity(toTp.getEntityId(), velocityVex.x, velocityVex.y, velocityVex.z);
                ((EntityPlayerMP)player).playerNetServerHandler.sendPacket((Packet)p);
            }
            if (powerUse > 0 && player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() instanceof IItemOfTravel) {
                ItemStack item = player.getCurrentEquippedItem().copy();
                ((IItemOfTravel)item.getItem()).extractInternal(item, powerUse);
                toTp.setCurrentItemOrArmor(0, item);
            }
        }
        return true;
    }
}

