/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.packet;

import com.enderio.core.common.TileEntityEnder;
import com.enderio.core.common.network.MessageTileEntity;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.api.teleport.ITravelAccessable;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PacketPassword
extends MessageTileEntity<TileEntityEnder> {
    private ItemStack stack;
    private int slot;
    private boolean setLabel;

    public PacketPassword() {
    }

    private PacketPassword(TileEntityEnder tile) {
        super((TileEntity)tile);
    }

    public static IMessage setPassword(TileEntityEnder te, int slot, ItemStack stack) {
        PacketPassword msg = new PacketPassword(te);
        msg.slot = slot;
        msg.stack = stack;
        msg.setLabel = false;
        return msg;
    }

    public static PacketPassword setLabel(TileEntityEnder te, ItemStack stack) {
        PacketPassword msg = new PacketPassword(te);
        msg.slot = 0;
        msg.stack = stack;
        msg.setLabel = true;
        return msg;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.slot = buf.readShort();
        this.setLabel = buf.readBoolean();
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort(this.slot);
        buf.writeBoolean(this.setLabel);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
    }

    public static class Handler
    implements IMessageHandler<PacketPassword, IMessage> {
        public IMessage onMessage(PacketPassword msg, MessageContext ctx) {
            TileEntityEnder te = (TileEntityEnder)msg.getTileEntity(ctx.getServerHandler().playerEntity.worldObj);
            if (te instanceof ITravelAccessable && ((ITravelAccessable)te).canUiBeAccessed((EntityPlayer)ctx.getServerHandler().playerEntity)) {
                if (msg.stack != null) {
                    ((PacketPassword)msg).stack.stackSize = 0;
                }
                if (msg.setLabel) {
                    ((ITravelAccessable)te).setItemLabel(msg.stack);
                } else {
                    ((ITravelAccessable)te).getPassword()[((PacketPassword)msg).slot] = msg.stack;
                    ((ITravelAccessable)te).clearAuthorisedUsers();
                }
                te.getWorldObj().markBlockForUpdate(msg.x, msg.y, msg.z);
            }
            return null;
        }
    }
}

