/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.api.teleport.ITravelAccessable;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;

public class PacketLabel
implements IMessage,
IMessageHandler<PacketLabel, IMessage> {
    int x;
    int y;
    int z;
    boolean labelNull;
    String label;

    public PacketLabel() {
    }

    public PacketLabel(int x, int y, int z, String label) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.label = label;
        this.labelNull = label == null || label.length() == 0;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeBoolean(this.labelNull);
        if (!this.labelNull) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.label);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.labelNull = buf.readBoolean();
        this.label = this.labelNull ? null : ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public IMessage onMessage(PacketLabel message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().playerEntity;
        TileEntity te = player.worldObj.getTileEntity(message.x, message.y, message.z);
        if (te instanceof ITravelAccessable) {
            ((ITravelAccessable)te).setLabel(message.label);
            player.worldObj.markBlockForUpdate(message.x, message.y, message.z);
            player.worldObj.markTileEntityChunkModified(message.x, message.y, message.z, te);
        }
        return null;
    }
}

