/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.api.teleport.ITravelAccessable;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;

public class PacketAccessMode
implements IMessage,
IMessageHandler<PacketAccessMode, IMessage> {
    int x;
    int y;
    int z;
    ITravelAccessable.AccessMode mode;

    public PacketAccessMode() {
    }

    public PacketAccessMode(int x, int y, int z, ITravelAccessable.AccessMode mode) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.mode = mode;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeShort(this.mode.ordinal());
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.mode = ITravelAccessable.AccessMode.values()[buf.readShort()];
    }

    public IMessage onMessage(PacketAccessMode message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().playerEntity;
        TileEntity te = player.worldObj.getTileEntity(message.x, message.y, message.z);
        if (te instanceof ITravelAccessable) {
            ((ITravelAccessable)te).setAccessMode(message.mode);
            player.worldObj.markBlockForUpdate(message.x, message.y, message.z);
            player.worldObj.markTileEntityChunkModified(message.x, message.y, message.z, te);
        }
        return null;
    }
}

