/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Camera;
import com.enderio.core.common.vecmath.Matrix4d;
import com.enderio.core.common.vecmath.VecmathUtil;
import com.enderio.core.common.vecmath.Vector2d;
import com.enderio.core.common.vecmath.Vector3d;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.api.teleport.TeleportEntityEvent;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.config.Config;
import crazypants.enderio.enderface.TileEnderIO;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.packet.PacketDrainStaff;
import crazypants.enderio.teleport.packet.PacketOpenAuthGui;
import crazypants.enderio.teleport.packet.PacketTravelEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovementInput;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TravelController {
    public static final TravelController instance = new TravelController();
    private Random rand = new Random();
    private boolean wasJumping = false;
    private boolean wasSneaking = false;
    private int delayTimer = 0;
    private int timer = Config.travelAnchorCooldown;
    private boolean tempJump;
    private boolean tempSneak;
    private boolean showTargets = false;
    public BlockCoord onBlockCoord;
    public BlockCoord selectedCoord;
    Camera currentView = new Camera();
    private final HashMap<BlockCoord, Float> candidates = new HashMap();
    private boolean selectionEnabled = true;
    private double fovRad;
    private double tanFovRad;
    private final List<GameRegistry.UniqueIdentifier> blackList = new ArrayList<GameRegistry.UniqueIdentifier>();

    private TravelController() {
        String[] blackListNames;
        for (String name : blackListNames = Config.travelStaffBlinkBlackList) {
            this.blackList.add(new GameRegistry.UniqueIdentifier(name));
        }
    }

    public void addBlockToBlinkBlackList(String blockName) {
        this.blackList.add(new GameRegistry.UniqueIdentifier(blockName));
    }

    public boolean activateTravelAccessable(ItemStack equipped, World world, EntityPlayer player, TravelSource source) {
        ITravelAccessable ta;
        if (!this.hasTarget()) {
            return false;
        }
        BlockCoord target = this.selectedCoord;
        TileEntity te = world.getTileEntity(target.x, target.y, target.z);
        if (te instanceof ITravelAccessable && (ta = (ITravelAccessable)te).getRequiresPassword(player)) {
            PacketOpenAuthGui p = new PacketOpenAuthGui(target.x, target.y, target.z);
            PacketHandler.INSTANCE.sendToServer((IMessage)p);
            return true;
        }
        if (this.isTargetEnderIO()) {
            this.openEnderIO(equipped, world, player);
        } else if (Config.travelAnchorEnabled) {
            this.travelToSelectedTarget(player, source, false);
        }
        return true;
    }

    public boolean doBlink(ItemStack equipped, EntityPlayer player) {
        Vector3d eye = Util.getEyePositionEio((EntityPlayer)player);
        Vector3d look = Util.getLookVecEio((EntityPlayer)player);
        Vector3d sample = new Vector3d(look);
        sample.scale((double)Config.travelStaffMaxBlinkDistance);
        sample.add(eye);
        Vec3 eye3 = Vec3.createVectorHelper((double)eye.x, (double)eye.y, (double)eye.z);
        Vec3 end = Vec3.createVectorHelper((double)sample.x, (double)sample.y, (double)sample.z);
        double playerHeight = player.yOffset;
        double lookComp = -look.y * playerHeight;
        double maxDistance = (double)Config.travelStaffMaxBlinkDistance + lookComp;
        MovingObjectPosition p = player.worldObj.rayTraceBlocks(eye3, end, !Config.travelStaffBlinkThroughClearBlocksEnabled);
        if (p == null) {
            for (double i = maxDistance; i > 1.0; i -= 1.0) {
                sample.set(look);
                sample.scale(i);
                sample.add(eye);
                sample.y -= playerHeight;
                if (!this.doBlinkAround(player, sample, true)) continue;
                return true;
            }
            return false;
        }
        List res = Util.raytraceAll((World)player.worldObj, (Vec3)eye3, (Vec3)end, (!Config.travelStaffBlinkThroughClearBlocksEnabled ? 1 : 0) != 0);
        for (MovingObjectPosition pos : res) {
            Block hitBlock;
            if (pos == null || !this.isBlackListedBlock(player, pos, hitBlock = player.worldObj.getBlock(pos.blockX, pos.blockY, pos.blockZ))) continue;
            maxDistance = Math.min(maxDistance, VecmathUtil.distance((Vector3d)eye, (Vector3d)new Vector3d((double)pos.blockX + 0.5, (double)pos.blockY + 0.5, (double)pos.blockZ + 0.5)) - 1.5 - lookComp);
        }
        eye3 = Vec3.createVectorHelper((double)eye.x, (double)eye.y, (double)eye.z);
        Vector3d targetBc = new Vector3d((double)p.blockX, (double)p.blockY, (double)p.blockZ);
        double sampleDistance = 1.5;
        double teleDistance = VecmathUtil.distance((Vector3d)eye, (Vector3d)new Vector3d((double)p.blockX + 0.5, (double)p.blockY + 0.5, (double)p.blockZ + 0.5)) + sampleDistance;
        while (teleDistance < maxDistance) {
            sample.set(look);
            sample.scale(sampleDistance);
            sample.add(targetBc);
            sample.y -= playerHeight;
            if (this.doBlinkAround(player, sample, false)) {
                return true;
            }
            teleDistance += 1.0;
            sampleDistance += 1.0;
        }
        sampleDistance = -0.5;
        for (teleDistance = VecmathUtil.distance((Vector3d)eye, (Vector3d)new Vector3d((double)p.blockX + 0.5, (double)p.blockY + 0.5, (double)p.blockZ + 0.5)) + sampleDistance; teleDistance > 1.0; teleDistance -= 1.0) {
            sample.set(look);
            sample.scale(sampleDistance);
            sample.add(targetBc);
            sample.y -= playerHeight;
            if (this.doBlinkAround(player, sample, false)) {
                return true;
            }
            sampleDistance -= 1.0;
        }
        return false;
    }

    private boolean isBlackListedBlock(EntityPlayer player, MovingObjectPosition pos, Block hitBlock) {
        GameRegistry.UniqueIdentifier ui = GameRegistry.findUniqueIdentifierFor((Block)hitBlock);
        if (ui == null) {
            return false;
        }
        return this.blackList.contains(ui) && (hitBlock.getBlockHardness(player.worldObj, pos.blockX, pos.blockY, pos.blockZ) < 0.0f || !Config.travelStaffBlinkThroughUnbreakableBlocksEnabled);
    }

    private boolean doBlinkAround(EntityPlayer player, Vector3d sample, boolean conserveMomentum) {
        if (this.doBlink(player, new BlockCoord((int)Math.floor(sample.x), (int)Math.floor(sample.y) - 1, (int)Math.floor(sample.z)), conserveMomentum)) {
            return true;
        }
        if (this.doBlink(player, new BlockCoord((int)Math.floor(sample.x), (int)Math.floor(sample.y), (int)Math.floor(sample.z)), conserveMomentum)) {
            return true;
        }
        return this.doBlink(player, new BlockCoord((int)Math.floor(sample.x), (int)Math.floor(sample.y) + 1, (int)Math.floor(sample.z)), conserveMomentum);
    }

    private boolean doBlink(EntityPlayer player, BlockCoord coord, boolean conserveMomentum) {
        return this.travelToLocation(player, TravelSource.STAFF_BLINK, coord, conserveMomentum);
    }

    public boolean showTargets() {
        return this.showTargets && this.selectionEnabled;
    }

    public void setSelectionEnabled(boolean b) {
        this.selectionEnabled = b;
        if (!this.selectionEnabled) {
            this.candidates.clear();
        }
    }

    public boolean isBlockSelected(BlockCoord coord) {
        if (coord == null) {
            return false;
        }
        return coord.equals((Object)this.selectedCoord);
    }

    public void addCandidate(BlockCoord coord) {
        if (!this.candidates.containsKey(coord)) {
            this.candidates.put(coord, Float.valueOf(-1.0f));
        }
    }

    public int getMaxTravelDistanceSq() {
        return TravelSource.getMaxDistanceSq();
    }

    public boolean isTargetEnderIO() {
        if (this.selectedCoord == null) {
            return false;
        }
        return EnderIO.proxy.getClientPlayer().worldObj.getBlock(this.selectedCoord.x, this.selectedCoord.y, this.selectedCoord.z) == EnderIO.blockEnderIo;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRender(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.getMinecraft();
        Vector3d eye = Util.getEyePositionEio((EntityPlayer)mc.thePlayer);
        Vector3d lookAt = Util.getLookVecEio((EntityPlayer)mc.thePlayer);
        lookAt.add(eye);
        Matrix4d mv = VecmathUtil.createMatrixAsLookAt((Vector3d)eye, (Vector3d)lookAt, (Vector3d)new Vector3d(0.0, 1.0, 0.0));
        float fov = Minecraft.getMinecraft().gameSettings.fovSetting;
        Matrix4d pr = VecmathUtil.createProjectionMatrixAsPerspective((double)fov, (double)0.05f, (double)(mc.gameSettings.renderDistanceChunks * 16), (int)mc.displayWidth, (int)mc.displayHeight);
        this.currentView.setProjectionMatrix(pr);
        this.currentView.setViewMatrix(mv);
        this.currentView.setViewport(0, 0, mc.displayWidth, mc.displayHeight);
        this.fovRad = Math.toRadians(fov);
        this.tanFovRad = Math.tanh(this.fovRad);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
            if (player == null) {
                return;
            }
            this.onBlockCoord = this.getActiveTravelBlock((EntityPlayer)player);
            boolean onBlock = this.onBlockCoord != null;
            boolean bl = this.showTargets = onBlock || this.isTravelItemActive((EntityPlayer)player);
            if (this.showTargets) {
                this.updateSelectedTarget((EntityPlayer)player);
            } else {
                this.selectedCoord = null;
            }
            MovementInput input = player.movementInput;
            this.tempJump = input.jump;
            this.tempSneak = input.sneak;
            if (input.jump && !this.wasJumping && onBlock && this.selectedCoord != null && this.delayTimer == 0 || input.sneak && !this.wasSneaking && onBlock && this.selectedCoord != null && this.delayTimer == 0 && Config.travelAnchorSneak) {
                this.onInput(player);
                this.delayTimer = this.timer;
            }
            if (input.jump && !this.wasJumping && onBlock && this.selectedCoord == null && this.delayTimer == 0) {
                this.updateVerticalTarget((EntityPlayer)player, 1);
                this.onInput(player);
                this.delayTimer = this.timer;
            }
            if (input.sneak && !this.wasSneaking && onBlock && this.selectedCoord == null && this.delayTimer == 0) {
                this.updateVerticalTarget((EntityPlayer)player, -1);
                this.onInput(player);
                this.delayTimer = this.timer;
            }
            if (this.delayTimer != 0) {
                --this.delayTimer;
            }
            this.wasJumping = this.tempJump;
            this.wasSneaking = this.tempSneak;
            this.candidates.clear();
        }
    }

    public boolean hasTarget() {
        return this.selectedCoord != null;
    }

    public void openEnderIO(ItemStack equipped, World world, EntityPlayer player) {
        BlockCoord target = TravelController.instance.selectedCoord;
        TileEntity te = world.getTileEntity(target.x, target.y, target.z);
        if (!(te instanceof TileEnderIO)) {
            return;
        }
        TileEnderIO eio = (TileEnderIO)te;
        if (eio.canBlockBeAccessed(player)) {
            int requiredPower;
            int n = requiredPower = equipped == null ? 0 : instance.getRequiredPower(player, TravelSource.STAFF, target);
            if (requiredPower <= 0 || requiredPower <= this.getEnergyInTravelItem(equipped)) {
                if (requiredPower > 0) {
                    PacketDrainStaff p = new PacketDrainStaff(requiredPower);
                    PacketHandler.INSTANCE.sendToServer((IMessage)p);
                }
                player.openGui((Object)EnderIO.instance, 1, world, target.x, TravelController.instance.selectedCoord.y, TravelController.instance.selectedCoord.z);
            }
        } else {
            player.addChatComponentMessage((IChatComponent)new ChatComponentTranslation("enderio.gui.travelAccessable.unauthorised", new Object[0]));
        }
    }

    public int getEnergyInTravelItem(ItemStack equipped) {
        if (equipped == null || !(equipped.getItem() instanceof IItemOfTravel)) {
            return 0;
        }
        return ((IItemOfTravel)equipped.getItem()).getEnergyStored(equipped);
    }

    public boolean isTravelItemActive(EntityPlayer ep) {
        if (ep == null || ep.getCurrentEquippedItem() == null) {
            return false;
        }
        ItemStack equipped = ep.getCurrentEquippedItem();
        if (equipped.getItem() instanceof IItemOfTravel) {
            return ((IItemOfTravel)equipped.getItem()).isActive(ep, equipped);
        }
        return false;
    }

    public boolean travelToSelectedTarget(EntityPlayer player, TravelSource source, boolean conserveMomentum) {
        return this.travelToLocation(player, source, this.selectedCoord, conserveMomentum);
    }

    public boolean travelToLocation(EntityPlayer player, TravelSource source, BlockCoord coord, boolean conserveMomentum) {
        ITravelAccessable ta;
        TileEntity te;
        if (source != TravelSource.STAFF_BLINK && (te = player.worldObj.getTileEntity(coord.x, coord.y, coord.z)) instanceof ITravelAccessable && !(ta = (ITravelAccessable)te).canBlockBeAccessed(player)) {
            player.addChatComponentMessage((IChatComponent)new ChatComponentTranslation("enderio.gui.travelAccessable.unauthorised", new Object[0]));
            return false;
        }
        int requiredPower = 0;
        requiredPower = this.getRequiredPower(player, source, coord);
        if (requiredPower < 0) {
            return false;
        }
        if (!this.isInRangeTarget(player, coord, source.getMaxDistanceTravelledSq())) {
            if (source != TravelSource.STAFF_BLINK) {
                player.addChatComponentMessage((IChatComponent)new ChatComponentTranslation("enderio.blockTravelPlatform.outOfRange", new Object[0]));
            }
            return false;
        }
        if (!this.isValidTarget(player, coord, source)) {
            if (source != TravelSource.STAFF_BLINK) {
                player.addChatComponentMessage((IChatComponent)new ChatComponentTranslation("enderio.blockTravelPlatform.invalidTarget", new Object[0]));
            }
            return false;
        }
        if (this.doClientTeleport((Entity)player, coord, source, requiredPower, conserveMomentum)) {
            for (int i = 0; i < 6; ++i) {
                player.worldObj.spawnParticle("portal", player.posX + (this.rand.nextDouble() - 0.5), player.posY + this.rand.nextDouble() * (double)player.height - 0.25, player.posZ + (this.rand.nextDouble() - 0.5), (this.rand.nextDouble() - 0.5) * 2.0, -this.rand.nextDouble(), (this.rand.nextDouble() - 0.5) * 2.0);
            }
        }
        return true;
    }

    public int getRequiredPower(EntityPlayer player, TravelSource source, BlockCoord coord) {
        int canUsePower;
        if (!this.isTravelItemActive(player)) {
            return 0;
        }
        ItemStack staff = player.getCurrentEquippedItem();
        int requiredPower = (int)(this.getDistance(player, coord) * (double)source.getPowerCostPerBlockTraveledRF());
        if (requiredPower > (canUsePower = this.getEnergyInTravelItem(staff))) {
            player.addChatComponentMessage((IChatComponent)new ChatComponentTranslation("enderio.itemTravelStaff.notEnoughPower", new Object[0]));
            return -1;
        }
        return requiredPower;
    }

    private boolean isInRangeTarget(EntityPlayer player, BlockCoord bc, float maxSq) {
        return this.getDistanceSquared(player, bc) <= (double)maxSq;
    }

    private double getDistanceSquared(EntityPlayer player, BlockCoord bc) {
        if (player == null || bc == null) {
            return 0.0;
        }
        Vector3d eye = Util.getEyePositionEio((EntityPlayer)player);
        Vector3d target = new Vector3d((double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5);
        return eye.distanceSquared(target);
    }

    private double getDistance(EntityPlayer player, BlockCoord coord) {
        return Math.sqrt(this.getDistanceSquared(player, coord));
    }

    private boolean isValidTarget(EntityPlayer player, BlockCoord bc, TravelSource source) {
        if (bc == null) {
            return false;
        }
        World w = player.worldObj;
        BlockCoord baseLoc = bc;
        if (source != TravelSource.STAFF_BLINK) {
            baseLoc = bc.getLocation(ForgeDirection.UP);
        }
        return this.canTeleportTo(player, source, baseLoc, w) && this.canTeleportTo(player, source, baseLoc.getLocation(ForgeDirection.UP), w);
    }

    private boolean canTeleportTo(EntityPlayer player, TravelSource source, BlockCoord bc, World w) {
        Vec3 target;
        Vec3 start;
        if (bc.y < 1) {
            return false;
        }
        if (source == TravelSource.STAFF_BLINK && !Config.travelStaffBlinkThroughSolidBlocksEnabled && !this.canBlinkTo(bc, w, start = Util.getEyePosition((EntityPlayer)player), target = Vec3.createVectorHelper((double)((float)bc.x + 0.5f), (double)((float)bc.y + 0.5f), (double)((float)bc.z + 0.5f)))) {
            return false;
        }
        Block block = w.getBlock(bc.x, bc.y, bc.z);
        if (block == null || block.isAir((IBlockAccess)w, bc.x, bc.y, bc.z)) {
            return true;
        }
        AxisAlignedBB aabb = block.getCollisionBoundingBoxFromPool(w, bc.x, bc.y, bc.z);
        return aabb == null || aabb.getAverageEdgeLength() < 0.7;
    }

    private boolean canBlinkTo(BlockCoord bc, World w, Vec3 start, Vec3 target) {
        MovingObjectPosition p = w.rayTraceBlocks(start, target, !Config.travelStaffBlinkThroughClearBlocksEnabled);
        if (p != null) {
            if (!Config.travelStaffBlinkThroughClearBlocksEnabled) {
                return false;
            }
            Block block = w.getBlock(p.blockX, p.blockY, p.blockZ);
            if (this.isClear(w, block, p.blockX, p.blockY, p.blockZ)) {
                if (new BlockCoord(p.blockX, p.blockY, p.blockZ).equals((Object)bc)) {
                    return true;
                }
                Vector3d sv = new Vector3d(start.xCoord, start.yCoord, start.zCoord);
                Vector3d rayDir = new Vector3d(target.xCoord, target.yCoord, target.zCoord);
                rayDir.sub(sv);
                rayDir.normalize();
                rayDir.add(sv);
                return this.canBlinkTo(bc, w, Vec3.createVectorHelper((double)rayDir.x, (double)rayDir.y, (double)rayDir.z), target);
            }
            return false;
        }
        return true;
    }

    private boolean isClear(World w, Block block, int x, int y, int z) {
        if (block == null || block.isAir((IBlockAccess)w, x, y, z)) {
            return true;
        }
        AxisAlignedBB aabb = block.getCollisionBoundingBoxFromPool(w, x, y, z);
        if (aabb == null || aabb.getAverageEdgeLength() < 0.7) {
            return true;
        }
        return block.getLightOpacity((IBlockAccess)w, x, y, z) < 2;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateVerticalTarget(EntityPlayer player, int direction) {
        BlockCoord currentBlock = this.getActiveTravelBlock(player);
        WorldClient world = Minecraft.getMinecraft().theWorld;
        int i = 0;
        for (int y = currentBlock.y + direction; i < Config.travelAnchorMaxDistance && y >= 0 && y <= 255; ++i, y += direction) {
            TileEntity selectedBlock = world.getTileEntity(currentBlock.x, y, currentBlock.z);
            if (!(selectedBlock instanceof ITravelAccessable)) continue;
            ITravelAccessable travelBlock = (ITravelAccessable)selectedBlock;
            BlockCoord targetBlock = new BlockCoord(currentBlock.x, y, currentBlock.z);
            if (Config.travelAnchorSkipWarning) {
                if (travelBlock.getRequiresPassword(player)) {
                    player.addChatComponentMessage((IChatComponent)new ChatComponentTranslation("enderio.gui.travelAccessable.skipLocked", new Object[0]));
                }
                if (travelBlock.getAccessMode() == ITravelAccessable.AccessMode.PRIVATE && !travelBlock.canUiBeAccessed(player)) {
                    player.addChatComponentMessage((IChatComponent)new ChatComponentTranslation("enderio.gui.travelAccessable.skipPrivate", new Object[0]));
                }
                if (!this.isValidTarget(player, targetBlock, TravelSource.BLOCK)) {
                    player.addChatComponentMessage((IChatComponent)new ChatComponentTranslation("enderio.gui.travelAccessable.skipObstructed", new Object[0]));
                }
            }
            if (!travelBlock.canBlockBeAccessed(player) || !this.isValidTarget(player, targetBlock, TravelSource.BLOCK)) continue;
            this.selectedCoord = targetBlock;
            return;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSelectedTarget(EntityPlayer player) {
        this.selectedCoord = null;
        if (this.candidates.isEmpty()) {
            return;
        }
        double closestDistance = Double.MAX_VALUE;
        for (BlockCoord bc : this.candidates.keySet()) {
            double d;
            if (bc.equals((Object)this.onBlockCoord) || !((d = this.addRatio(bc)) < closestDistance)) continue;
            this.selectedCoord = bc;
            closestDistance = d;
        }
        if (this.selectedCoord != null) {
            Vector3d blockCenter = new Vector3d((double)this.selectedCoord.x + 0.5, (double)this.selectedCoord.y + 0.5, (double)this.selectedCoord.z + 0.5);
            Vector2d blockCenterPixel = this.currentView.getScreenPoint(blockCenter);
            Vector2d screenMidPixel = new Vector2d((double)Minecraft.getMinecraft().displayWidth, (double)Minecraft.getMinecraft().displayHeight);
            screenMidPixel.scale(0.5);
            double pixDist = blockCenterPixel.distance(screenMidPixel);
            double rat = pixDist / (double)Minecraft.getMinecraft().displayHeight;
            if (rat != rat) {
                rat = 0.0;
            }
            if (rat > 0.07) {
                this.selectedCoord = null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onInput(EntityClientPlayerMP player) {
        ITravelAccessable ta;
        MovementInput input = player.movementInput;
        BlockCoord target = TravelController.instance.selectedCoord;
        if (target == null) {
            return;
        }
        TileEntity te = player.worldObj.getTileEntity(target.x, target.y, target.z);
        if (te instanceof ITravelAccessable && (ta = (ITravelAccessable)te).getRequiresPassword((EntityPlayer)player)) {
            PacketOpenAuthGui p = new PacketOpenAuthGui(target.x, target.y, target.z);
            PacketHandler.INSTANCE.sendToServer((IMessage)p);
            return;
        }
        if (this.isTargetEnderIO()) {
            this.openEnderIO(null, player.worldObj, (EntityPlayer)player);
        } else if (Config.travelAnchorEnabled && this.travelToSelectedTarget((EntityPlayer)player, TravelSource.BLOCK, false)) {
            input.jump = false;
            try {
                ObfuscationReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)player, (Object)0, (String[])new String[]{"flyToggleTimer", "field_71101_bC"});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public double getScaleForCandidate(Vector3d loc) {
        if (!this.currentView.isValid()) {
            return 1.0;
        }
        BlockCoord bc = new BlockCoord(loc.x, loc.y, loc.z);
        float ratio = -1.0f;
        Float r = this.candidates.get(bc);
        if (r != null) {
            ratio = r.floatValue();
        }
        if (ratio < 0.0f) {
            this.addRatio(bc);
            ratio = this.candidates.get(bc).floatValue();
        }
        float start = 0.2f;
        float end = 0.01f;
        double mix = MathHelper.clamp_float((float)((start - ratio) / (start - end)), (float)0.0f, (float)1.0f);
        double scale = 1.0;
        if (mix > 0.0) {
            Vector3d eyePoint = Util.getEyePositionEio((EntityPlayer)EnderIO.proxy.getClientPlayer());
            scale = this.tanFovRad * eyePoint.distance(loc);
            scale *= (double)Config.travelAnchorZoomScale;
            float nf = 1.0f - MathHelper.clamp_float((float)((float)eyePoint.distanceSquared(loc) / (float)TravelSource.STAFF.getMaxDistanceTravelledSq()), (float)0.0f, (float)1.0f);
            scale *= 0.3 + 0.7 * (double)nf;
            scale = scale * mix + (1.0 - mix);
            scale = Math.max(1.0, scale);
        }
        return scale;
    }

    @SideOnly(value=Side.CLIENT)
    private double addRatio(BlockCoord bc) {
        Vector2d sp = this.currentView.getScreenPoint(new Vector3d((double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5));
        Vector2d mid = new Vector2d((double)Minecraft.getMinecraft().displayWidth, (double)Minecraft.getMinecraft().displayHeight);
        mid.scale(0.5);
        double d = sp.distance(mid);
        if (d != d) {
            d = 0.0;
        }
        float ratio = (float)d / (float)Minecraft.getMinecraft().displayWidth;
        this.candidates.put(bc, Float.valueOf(ratio));
        return d;
    }

    @SideOnly(value=Side.CLIENT)
    private int getMaxTravelDistanceSqForPlayer(EntityPlayer player) {
        if (this.isTravelItemActive(player)) {
            return TravelSource.STAFF.getMaxDistanceTravelledSq();
        }
        return TravelSource.BLOCK.getMaxDistanceTravelledSq();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean doClientTeleport(Entity entity, BlockCoord bc, TravelSource source, int powerUse, boolean conserveMomentum) {
        TeleportEntityEvent evt = new TeleportEntityEvent(entity, source, bc.x, bc.y, bc.z);
        if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
            return false;
        }
        bc = new BlockCoord(evt.targetX, evt.targetY, evt.targetZ);
        PacketTravelEvent p = new PacketTravelEvent(entity, bc.x, bc.y, bc.z, powerUse, conserveMomentum, source);
        PacketHandler.INSTANCE.sendToServer((IMessage)p);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private BlockCoord getActiveTravelBlock(EntityPlayer player) {
        int z;
        int y;
        int x;
        WorldClient world = Minecraft.getMinecraft().theWorld;
        if (world != null && player != null && world.getBlock(x = MathHelper.floor_double((double)player.posX), y = MathHelper.floor_double((double)player.boundingBox.minY) - 1, z = MathHelper.floor_double((double)player.posZ)) == EnderIO.blockTravelPlatform) {
            return new BlockCoord(x, y, z);
        }
        return null;
    }
}

