/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.rail;

import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.rail.CartLinkUtil;
import crazypants.enderio.rail.ICartLinkUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.ILinkageManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RailcraftLinkUtil
implements ICartLinkUtil {
    private Class<?> directionalClass;

    public RailcraftLinkUtil() throws Exception {
        Class.forName("mods.railcraft.api.carts.CartTools");
        try {
            this.directionalClass = Class.forName("mods.railcraft.common.carts.IDirectionalCart");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setCartDirection(EntityMinecart cart, ForgeDirection dir) {
        if (!this.isDirectional(cart)) {
            CartLinkUtil.defaultInstance.setCartDirection(cart, dir);
            return;
        }
        ForgeDirection oldDir = this.getCurrentDir(cart);
        CartLinkUtil.defaultInstance.setCartDirection(cart, dir);
        ForgeDirection newDir = this.getCurrentDir(cart);
        if (oldDir.getOpposite() == newDir) {
            cart.rotationYaw += 180.0f;
        }
    }

    private boolean isDirectional(EntityMinecart cart) {
        if (this.directionalClass == null) {
            return false;
        }
        return this.directionalClass.isAssignableFrom(cart.getClass());
    }

    private ForgeDirection getCurrentDir(EntityMinecart cart) {
        boolean isNeg;
        boolean isX = true;
        boolean bl = isNeg = cart.motionX < 0.0;
        if (Math.abs(cart.motionZ) > Math.abs(cart.motionX)) {
            isX = false;
            boolean bl2 = isNeg = cart.motionZ < 0.0;
        }
        if (isX) {
            return isNeg ? ForgeDirection.WEST : ForgeDirection.EAST;
        }
        return isNeg ? ForgeDirection.NORTH : ForgeDirection.SOUTH;
    }

    @Override
    public void breakLinks(World world, Entity cart) {
        if (cart instanceof EntityMinecart) {
            this.breakLinks(world, (EntityMinecart)cart);
        }
    }

    public void breakLinks(World world, EntityMinecart cart) {
        if (world == null || cart == null) {
            return;
        }
        ILinkageManager linkMan = CartTools.getLinkageManager((World)world);
        if (linkMan == null) {
            return;
        }
        linkMan.breakLinks(cart);
    }

    public void recreateLink(EntityMinecart existingCart, EntityMinecart newCart) {
        if (existingCart == null || newCart == null) {
            return;
        }
        ILinkageManager linkMan = CartTools.getLinkageManager((World)existingCart.worldObj);
        if (linkMan == null) {
            return;
        }
        UUID linkA = this.getLinkA(newCart);
        if (linkA != null && linkA.equals(existingCart.getPersistentID())) {
            if (!linkMan.areLinked(existingCart, newCart)) {
                boolean bl = linkMan.createLink(existingCart, newCart);
            }
            return;
        }
        UUID linkB = this.getLinkB(newCart);
        if (linkB != null && linkB.equals(existingCart.getPersistentID())) {
            if (!linkMan.areLinked(existingCart, newCart)) {
                boolean bl = linkMan.createLink(existingCart, newCart);
            }
            return;
        }
    }

    @Override
    public void updateCartLinks(World world, EntityMinecart cart) {
        ILinkageManager linkMan = CartTools.getLinkageManager((World)cart.worldObj);
        if (linkMan == null || linkMan.countCartsInTrain(cart) <= 1) {
            return;
        }
        Iterable allCarts = linkMan.getCartsInTrain(cart);
        for (EntityMinecart aCart : allCarts) {
            if (aCart == null) continue;
            this.updateLink("a", aCart, linkMan.getLinkedCartA(aCart));
            this.updateLink("b", aCart, linkMan.getLinkedCartB(aCart));
        }
    }

    private void updateLink(String prefix, EntityMinecart cart, EntityMinecart linkedCart) {
        NBTTagCompound data = cart.getEntityData();
        long lastUpdateTime = -1L;
        String timeKey = prefix + "UpdateTime";
        if (data.hasKey(timeKey)) {
            lastUpdateTime = data.getLong(timeKey);
        }
        long curTime = cart.worldObj.getTotalWorldTime();
        if (lastUpdateTime > 0L && curTime - lastUpdateTime < 100L) {
            return;
        }
        data.setLong(timeKey, curTime);
        data.setString(prefix + "Link", linkedCart == null ? "null" : linkedCart.getPersistentID().toString());
    }

    public UUID getLinkA(EntityMinecart cart) {
        return this.getLink("a", cart);
    }

    public UUID getLinkB(EntityMinecart cart) {
        return this.getLink("b", cart);
    }

    private UUID getLink(String prefix, EntityMinecart cart) {
        NBTTagCompound data = cart.getEntityData();
        String uuidStr = data.getString(prefix + "Link");
        if (uuidStr == null || uuidStr.trim().isEmpty() || "null".equals(uuidStr)) {
            return null;
        }
        return UUID.fromString(uuidStr);
    }

    @Override
    public int getNumberOfCartsInTrain(EntityMinecart cart) {
        if (cart == null) {
            return 0;
        }
        ILinkageManager linkMan = CartTools.getLinkageManager((World)cart.worldObj);
        if (linkMan == null) {
            return 1;
        }
        return linkMan.countCartsInTrain(cart);
    }

    @Override
    public List<EntityMinecart> getCartsInTrain(EntityMinecart cart) {
        if (cart == null) {
            Collections.emptyList();
        }
        ArrayList<EntityMinecart> result = new ArrayList<EntityMinecart>();
        ILinkageManager linkMan = CartTools.getLinkageManager((World)cart.worldObj);
        if (linkMan == null) {
            result.add(cart);
            return result;
        }
        Iterable iter = linkMan.getCartsInTrain(cart);
        for (EntityMinecart cartInTrain : iter) {
            if (cartInTrain == null) continue;
            result.add(cartInTrain);
        }
        Collections.sort(result, new TrainOrderComparator(cart));
        return result;
    }

    @Override
    public void recreateLinks(EntityMinecart cart) {
        ILinkageManager linkMan = CartTools.getLinkageManager((World)cart.worldObj);
        if (linkMan == null) {
            return;
        }
        this.recreateLink(cart, linkMan, this.getLinkA(cart));
        this.recreateLink(cart, linkMan, this.getLinkB(cart));
    }

    private void recreateLink(EntityMinecart cart, ILinkageManager linkMan, UUID uuid) {
        EntityMinecart linkTo;
        if (uuid != null && !linkMan.areLinked(cart, linkTo = linkMan.getCartFromUUID(uuid))) {
            linkMan.createLink(cart, linkTo);
        }
    }

    private static class TrainOrderComparator
    implements Comparator<EntityMinecart> {
        private final Vector3d refPoint = new Vector3d();
        private final Vector3d loc1 = new Vector3d();
        private final Vector3d loc2 = new Vector3d();
        private double d1;
        private double d2;

        TrainOrderComparator(EntityMinecart head) {
            this.set(this.refPoint, head);
        }

        @Override
        public int compare(EntityMinecart o1, EntityMinecart o2) {
            this.set(this.loc1, o1);
            this.set(this.loc2, o2);
            this.d1 = this.refPoint.distanceSquared(this.loc1);
            this.d2 = this.refPoint.distanceSquared(this.loc2);
            return Double.compare(this.d1, this.d2);
        }

        private void set(Vector3d point, EntityMinecart cart) {
            point.set(cart.posX, cart.posY, cart.posZ);
        }
    }
}

