/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import com.enderio.core.common.util.OreDictionaryHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.ItemEnderFood;
import crazypants.enderio.material.Alloy;
import crazypants.enderio.material.BlockFusedQuartz;
import crazypants.enderio.material.MachinePart;
import crazypants.enderio.material.Material;
import crazypants.enderio.material.OreDictionaryPreferences;
import crazypants.enderio.material.PowderIngot;
import crazypants.util.RecipeUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class MaterialRecipes {
    public static void registerDependantOresInDictionary() {
        for (PowderIngot powder : PowderIngot.values()) {
            if (!powder.hasDependancy() || !powder.isDependancyMet()) continue;
            OreDictionary.registerOre((String)powder.oreDictName, (ItemStack)new ItemStack((Item)EnderIO.itemPowderIngot, 1, powder.ordinal()));
            powder.setRegistered();
        }
    }

    public static void registerOresInDictionary() {
        for (PowderIngot powderIngot : PowderIngot.values()) {
            if (powderIngot.hasDependancy()) continue;
            OreDictionary.registerOre((String)powderIngot.oreDictName, (ItemStack)new ItemStack((Item)EnderIO.itemPowderIngot, 1, powderIngot.ordinal()));
        }
        for (Enum enum_ : Alloy.values()) {
            boolean isPrimaryName = true;
            for (String oreDictName : ((Alloy)enum_).getOreIngots()) {
                OreDictionary.registerOre((String)oreDictName, (ItemStack)((Alloy)enum_).getStackIngot());
                if (isPrimaryName) {
                    isPrimaryName = false;
                    continue;
                }
                RecipeUtil.addShapeless(((Alloy)enum_).getStackIngot(2), oreDictName, oreDictName);
            }
            isPrimaryName = true;
            for (String oreDictName : ((Alloy)enum_).getOreBlocks()) {
                OreDictionary.registerOre((String)oreDictName, (ItemStack)((Alloy)enum_).getStackBlock());
                if (isPrimaryName) {
                    isPrimaryName = false;
                    continue;
                }
                RecipeUtil.addShapeless(((Alloy)enum_).getStackBlock(2), oreDictName, oreDictName);
            }
        }
        OreDictionary.registerOre((String)"nuggetPulsatingIron", (ItemStack)new ItemStack((Item)EnderIO.itemMaterial, 1, Material.PHASED_IRON_NUGGET.ordinal()));
        OreDictionary.registerOre((String)"nuggetVibrantAlloy", (ItemStack)new ItemStack((Item)EnderIO.itemMaterial, 1, Material.VIBRANT_NUGGET.ordinal()));
        OreDictionary.registerOre((String)"glass", (Block)Blocks.glass);
        OreDictionary.registerOre((String)"stickWood", (Item)Items.stick);
        OreDictionary.registerOre((String)"woodStick", (Item)Items.stick);
        OreDictionary.registerOre((String)"sand", (ItemStack)new ItemStack((Block)Blocks.sand, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"ingotIron", (Item)Items.iron_ingot);
        OreDictionary.registerOre((String)"ingotGold", (Item)Items.gold_ingot);
        ItemStack pureGlass = new ItemStack((Block)EnderIO.blockFusedQuartz, 1, BlockFusedQuartz.Type.GLASS.ordinal());
        OreDictionary.registerOre((String)"glass", (ItemStack)pureGlass);
        OreDictionary.registerOre((String)"blockGlass", (ItemStack)pureGlass);
        OreDictionary.registerOre((String)"blockGlassHardened", (ItemStack)new ItemStack((Block)EnderIO.blockFusedQuartz, 1, BlockFusedQuartz.Type.FUSED_QUARTZ.ordinal()));
        ItemStack skull = new ItemStack(Items.skull, 1, Short.MAX_VALUE);
        OreDictionary.registerOre((String)"itemSkull", (ItemStack)skull);
        OreDictionary.registerOre((String)"itemSkull", (ItemStack)new ItemStack((Block)EnderIO.blockEndermanSkull));
        RecipeUtil.addShaped(new ItemStack(Blocks.glass_pane, 16, 0), "eee", "eee", Character.valueOf('e'), pureGlass);
        RecipeUtil.addShapeless(new ItemStack(Blocks.glass), pureGlass);
        RecipeUtil.addShaped(new ItemStack(Items.glass_bottle, 3, 0), "g g", " g ", Character.valueOf('g'), pureGlass);
        Material.registerOres(EnderIO.itemMaterial);
        MachinePart.registerOres(EnderIO.itemMachinePart);
    }

    public static void addRecipes() {
        String conduitBinder = Material.CONDUIT_BINDER.oreDict;
        ItemStack fusedQuartzFrame = new ItemStack((Item)EnderIO.itemFusedQuartzFrame, 1, 0);
        String energeticAlloy = Alloy.ENERGETIC_ALLOY.getOreIngot();
        String phasedGold = Alloy.PHASED_GOLD.getOreIngot();
        String phasedIron = Alloy.PHASED_IRON.getOreIngot();
        String darkSteel = Alloy.DARK_STEEL.getOreIngot();
        ItemStack capacitor = new ItemStack((Item)EnderIO.itemBasicCapacitor, 1, 0);
        ItemStack cbc = Material.BINDER_COMPOSITE.getStack(8);
        if (Config.useAlternateBinderRecipe) {
            RecipeUtil.addShaped(cbc, "gcg", "sgs", "gcg", Character.valueOf('g'), Blocks.gravel, Character.valueOf('s'), "sand", Character.valueOf('c'), Items.clay_ball);
        } else {
            RecipeUtil.addShaped(cbc, "ggg", "scs", "ggg", Character.valueOf('g'), Blocks.gravel, Character.valueOf('s'), "sand", Character.valueOf('c'), Items.clay_ball);
        }
        GameRegistry.addSmelting((ItemStack)Material.BINDER_COMPOSITE.getStack(), (ItemStack)Material.CONDUIT_BINDER.getStack(4), (float)0.0f);
        ItemStack phasedIronNugget = new ItemStack((Item)EnderIO.itemMaterial, 9, Material.PHASED_IRON_NUGGET.ordinal());
        RecipeUtil.addShapeless(phasedIronNugget, phasedIron);
        phasedIronNugget = phasedIronNugget.copy();
        phasedIronNugget.stackSize = 1;
        RecipeUtil.addShaped(Alloy.PHASED_IRON.getStackIngot(), "eee", "eee", "eee", Character.valueOf('e'), phasedIronNugget);
        ItemStack vibrantNugget = new ItemStack((Item)EnderIO.itemMaterial, 9, Material.VIBRANT_NUGGET.ordinal());
        RecipeUtil.addShapeless(vibrantNugget, phasedGold);
        vibrantNugget = vibrantNugget.copy();
        vibrantNugget.stackSize = 1;
        RecipeUtil.addShaped(Alloy.PHASED_GOLD.getStackIngot(), "eee", "eee", "eee", Character.valueOf('e'), vibrantNugget);
        ItemStack pulsCry = new ItemStack((Item)EnderIO.itemMaterial, 1, Material.PULSATING_CYSTAL.ordinal());
        RecipeUtil.addShaped(pulsCry, "nnn", "ngn", "nnn", Character.valueOf('n'), phasedIronNugget, Character.valueOf('g'), "gemDiamond");
        ItemStack vibCry = new ItemStack((Item)EnderIO.itemMaterial, 1, Material.VIBRANT_CYSTAL.ordinal());
        RecipeUtil.addShaped(vibCry, "nnn", "ngn", "nnn", Character.valueOf('n'), vibrantNugget, Character.valueOf('g'), "gemEmerald");
        ItemStack darkBall = new ItemStack((Item)EnderIO.itemMaterial, 5, Material.DARK_GRINDING_BALL.ordinal());
        RecipeUtil.addShaped(darkBall, " s ", "sss", " s ", Character.valueOf('s'), darkSteel);
        ItemStack dustIron = new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_IRON.ordinal());
        ItemStack dustGold = new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_GOLD.ordinal());
        ItemStack ingotIron = new ItemStack(Items.iron_ingot);
        ItemStack ingotGold = new ItemStack(Items.gold_ingot);
        GameRegistry.addSmelting((ItemStack)dustIron, (ItemStack)ingotIron, (float)0.0f);
        GameRegistry.addSmelting((ItemStack)dustGold, (ItemStack)ingotGold, (float)0.0f);
        ItemStack enderDust = new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_ENDER.ordinal());
        RecipeUtil.addShaped(new ItemStack(Items.ender_pearl), "eee", "eee", "eee", Character.valueOf('e'), enderDust);
        ItemStack diBars = new ItemStack((Block)EnderIO.blockDarkIronBars, 16, 0);
        RecipeUtil.addShaped(diBars, "ddd", "ddd", Character.valueOf('d'), darkSteel);
        RecipeUtil.addShaped(fusedQuartzFrame, "bsb", "s s", "bsb", Character.valueOf('b'), conduitBinder, Character.valueOf('s'), "stickWood");
        RecipeUtil.addShaped(fusedQuartzFrame, "bsb", "s s", "bsb", Character.valueOf('b'), conduitBinder, Character.valueOf('s'), "woodStick");
        ArrayList steelIngots = OreDictionary.getOres((String)"ingotSteel");
        ItemStack chassis = new ItemStack((Item)EnderIO.itemMachinePart, 1, MachinePart.MACHINE_CHASSI.ordinal());
        String mat = Config.useSteelInChassi && steelIngots != null && !steelIngots.isEmpty() ? "ingotSteel" : "ingotIron";
        RecipeUtil.addShaped(chassis, "fif", "ici", "fif", Character.valueOf('f'), Blocks.iron_bars, Character.valueOf('i'), mat, Character.valueOf('c'), capacitor);
        ItemStack gear = new ItemStack((Item)EnderIO.itemMachinePart, 1, MachinePart.BASIC_GEAR.ordinal());
        RecipeUtil.addShaped(gear, "scs", "c c", "scs", Character.valueOf('s'), "stickWood", Character.valueOf('c'), "cobblestone");
        RecipeUtil.addShaped(gear, "scs", "c c", "scs", Character.valueOf('s'), "woodStick", Character.valueOf('c'), "cobblestone");
        ItemStack enderCapacitor = new ItemStack((Item)EnderIO.itemBasicCapacitor, 1, 2);
        ItemStack activatedCapacitor = new ItemStack((Item)EnderIO.itemBasicCapacitor, 1, 1);
        if (Config.useHardRecipes) {
            RecipeUtil.addShaped(enderCapacitor, "eee", "cgc", "eee", Character.valueOf('e'), phasedGold, Character.valueOf('c'), activatedCapacitor, Character.valueOf('g'), "glowstone");
        } else {
            RecipeUtil.addShaped(enderCapacitor, " e ", "cgc", " e ", Character.valueOf('e'), phasedGold, Character.valueOf('c'), activatedCapacitor, Character.valueOf('g'), "glowstone");
        }
        ItemStack main = Config.useHardRecipes ? new ItemStack((Item)EnderIO.itemMaterial, 1, Material.VIBRANT_CYSTAL.ordinal()) : new ItemStack(Items.diamond);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)EnderIO.itemMaterial, 1, Material.WEATHER_CRYSTAL.ordinal()), new Object[]{main}));
        if (Config.reinforcedObsidianEnabled) {
            Alloy[] reinfObs = new ItemStack((Block)EnderIO.blockReinforcedObsidian);
            String corners = darkSteel;
            if (Config.reinforcedObsidianUseDarkSteelBlocks) {
                corners = Alloy.DARK_STEEL.getOreBlock();
            }
            RecipeUtil.addShaped((ItemStack)reinfObs, new Object[]{"dbd", "bob", "dbd", Character.valueOf('d'), corners, Character.valueOf('b'), EnderIO.blockDarkIronBars, Character.valueOf('o'), Blocks.obsidian});
        }
        RecipeUtil.addShaped((Block)EnderIO.blockDarkSteelAnvil, "bbb", " i ", "iii", Character.valueOf('b'), Alloy.DARK_STEEL.getOreBlock(), Character.valueOf('i'), darkSteel);
        RecipeUtil.addShaped(new ItemStack((Block)EnderIO.blockDarkSteelLadder, 12), new Object[]{"b", "b", "b", Character.valueOf('b'), EnderIO.blockDarkIronBars});
        for (Alloy alloy : Alloy.values()) {
            RecipeUtil.addShaped(alloy.getStackBlock(), "iii", "iii", "iii", Character.valueOf('i'), alloy.getOreIngot());
            RecipeUtil.addShapeless(alloy.getStackIngot(9), alloy.getOreBlock());
        }
        ItemStack flour = new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.FLOUR.ordinal());
        ItemStack bread = new ItemStack(Items.bread, 1, 0);
        GameRegistry.addSmelting((ItemStack)flour, (ItemStack)bread, (float)0.35f);
        ItemStack enderios = ItemEnderFood.EnderFood.ENDERIOS.getStack();
        RecipeUtil.addShapeless(enderios, Items.bowl, Items.milk_bucket, "cropWheat", "dustEnderPearl");
        if (OreDictionaryHelper.hasCopper()) {
            ItemStack dustCopper = new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_COPPER.ordinal());
            ItemStack ingotCopper = OreDictionaryPreferences.instance.getPreferred("ingotCopper");
            GameRegistry.addSmelting((ItemStack)dustCopper, (ItemStack)ingotCopper, (float)0.0f);
        }
        if (OreDictionaryHelper.hasTin()) {
            ItemStack dustTin = new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_TIN.ordinal());
            ItemStack ingotTin = OreDictionaryPreferences.instance.getPreferred("ingotTin");
            GameRegistry.addSmelting((ItemStack)dustTin, (ItemStack)ingotTin, (float)0.0f);
        }
        ArrayList copperIngots = OreDictionary.getOres((String)"ingotCopper");
        String gold = Config.useHardRecipes ? "ingotGold" : "nuggetGold";
        if (copperIngots != null && !copperIngots.isEmpty() && Config.useModMetals) {
            RecipeUtil.addShaped(capacitor, " gr", "gcg", "rg ", Character.valueOf('r'), "dustRedstone", Character.valueOf('g'), gold, Character.valueOf('c'), "ingotCopper");
        } else {
            RecipeUtil.addShaped(capacitor, " gr", "gig", "rg ", Character.valueOf('r'), "dustRedstone", Character.valueOf('g'), gold, Character.valueOf('i'), "ingotIron");
        }
        if (Config.useHardRecipes) {
            RecipeUtil.addShaped(activatedCapacitor, "eee", "cCc", "eee", Character.valueOf('e'), energeticAlloy, Character.valueOf('c'), capacitor, Character.valueOf('C'), "dustCoal");
        } else {
            RecipeUtil.addShaped(activatedCapacitor, " e ", "cCc", " e ", Character.valueOf('e'), energeticAlloy, Character.valueOf('c'), capacitor, Character.valueOf('C'), "dustCoal");
        }
    }
}

