/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.wireless;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.wireless.TileWirelessCharger;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketStoredEnergy
implements IMessage,
IMessageHandler<PacketStoredEnergy, IMessage> {
    private int x;
    private int y;
    private int z;
    private int storedEnergy;

    public PacketStoredEnergy() {
    }

    public PacketStoredEnergy(TileWirelessCharger ent) {
        this.x = ent.xCoord;
        this.y = ent.yCoord;
        this.z = ent.zCoord;
        this.storedEnergy = ent.storedEnergyRF;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.storedEnergy);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.storedEnergy = buf.readInt();
    }

    public IMessage onMessage(PacketStoredEnergy message, MessageContext ctx) {
        EntityPlayer player = EnderIO.proxy.getClientPlayer();
        TileEntity te = player.worldObj.getTileEntity(message.x, message.y, message.z);
        if (te instanceof TileWirelessCharger) {
            TileWirelessCharger me = (TileWirelessCharger)te;
            boolean doRender = me.storedEnergyRF <= 0 && message.storedEnergy > 0 || me.storedEnergyRF > 0 && message.storedEnergy <= 0;
            me.storedEnergyRF = message.storedEnergy;
            if (doRender) {
                player.worldObj.markBlockRangeForRenderUpdate(message.x, message.y, message.z, message.x, message.y, message.z);
            }
        }
        return null;
    }
}

