/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vacuum;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.vacuum.BlockVacuumChest;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;

public class VacuumChestRenderer
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        Tessellator.instance.startDrawingQuads();
        CubeRenderer.render((BoundingBox)BoundingBox.UNIT_CUBE.scale(0.6, 0.6, 0.6), (IIcon)EnderIO.blockHyperCube.getIcon(0, 0));
        CubeRenderer.render((BoundingBox)BoundingBox.UNIT_CUBE.scale(0.9, 0.9, 0.9), (IIcon)EnderIO.blockVacuumChest.getIcon(0, 0));
        Tessellator.instance.draw();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        IIcon override = renderer.overrideBlockTexture;
        double size = 0.4;
        renderer.renderMinX = 0.5 - size;
        renderer.renderMaxX = 0.5 + size;
        renderer.renderMinY = 0.5 - size;
        renderer.renderMaxY = 0.5 + size;
        renderer.renderMinZ = 0.5 - size;
        renderer.renderMaxZ = 0.5 + size;
        renderer.lockBlockBounds = true;
        if (!renderer.hasOverrideBlockTexture()) {
            renderer.setOverrideBlockTexture(EnderIO.blockHyperCube.getIcon(0, 0));
        }
        renderer.renderStandardBlock(Blocks.stone, x, y, z);
        renderer.setOverrideBlockTexture(override);
        renderer.lockBlockBounds = false;
        renderer.renderMinX = 0.0;
        renderer.renderMaxX = 1.0;
        renderer.renderMinY = 0.0;
        renderer.renderMaxY = 1.0;
        renderer.renderMinZ = 0.0;
        renderer.renderMaxZ = 1.0;
        if (!renderer.hasOverrideBlockTexture()) {
            renderer.setOverrideBlockTexture(EnderIO.blockVacuumChest.getIcon(0, 0));
        }
        renderer.renderStandardBlock(Blocks.stone, x, y, z);
        renderer.setOverrideBlockTexture(override);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BlockVacuumChest.renderId;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.renderInventoryBlock(Block.getBlockFromItem((Item)item.getItem()), item.getItemDamage(), 0, (RenderBlocks)data[0]);
    }
}

