/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vacuum;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.ItemUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.conduit.item.FilterRegister;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.conduit.item.filter.ItemFilter;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.RedstoneControlMode;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileVacuumChest
extends TileEntityEio
implements IEntitySelector,
IInventory,
IRedstoneModeControlable {
    public static final int ITEM_ROWS = 3;
    public static final int ITEM_SLOTS = 27;
    public static final int FILTER_SLOTS = 5;
    private final ItemStack[] inv = new ItemStack[27];
    private int range = Config.vacuumChestRange;
    private ItemFilter filter;
    private ItemStack filterItem;
    protected RedstoneControlMode redstoneControlMode = RedstoneControlMode.IGNORE;
    protected boolean redstoneCheckPassed;
    private boolean redstoneStateDirty = true;

    public void doUpdate() {
        if (this.redstoneStateDirty) {
            this.updateRedstoneStatus();
        }
        if (this.redstoneCheckPassed && !this.isFull()) {
            this.doHoover();
        }
    }

    private void updateRedstoneStatus() {
        boolean prevRedstoneCheckPassed = this.redstoneCheckPassed;
        this.redstoneCheckPassed = RedstoneControlMode.isConditionMet(this.redstoneControlMode, (TileEntity)this);
        this.redstoneStateDirty = false;
        if (this.redstoneCheckPassed != prevRedstoneCheckPassed) {
            this.updateBlock();
        }
    }

    public void onNeighborBlockChange(Block blockId) {
        this.redstoneStateDirty = true;
    }

    public boolean isEntityApplicable(Entity entity) {
        if (entity.isDead) {
            return false;
        }
        if (entity instanceof IProjectile) {
            return entity.motionY < 0.01;
        }
        return entity instanceof EntityItem;
    }

    private void doHoover() {
        int rangeSqr = this.range * this.range;
        BoundingBox bb = new BoundingBox(this.getLocation());
        AxisAlignedBB aabb = AxisAlignedBB.getBoundingBox((double)bb.minX, (double)bb.minY, (double)bb.minZ, (double)bb.maxX, (double)bb.maxY, (double)bb.maxZ);
        aabb = aabb.expand((double)this.range, (double)this.range, (double)this.range);
        List interestingItems = this.worldObj.selectEntitiesWithinAABB(EntityItem.class, aabb, (IEntitySelector)this);
        for (EntityItem entity : interestingItems) {
            if (this.filter != null && !this.filter.doesItemPassFilter(entity.getEntityItem())) continue;
            double x = (double)this.xCoord + 0.5 - entity.posX;
            double y = (double)this.yCoord + 0.5 - entity.posY;
            double z = (double)this.zCoord + 0.5 - entity.posZ;
            double distance = Math.sqrt(x * x + y * y + z * z);
            if (distance < 1.25) {
                this.hooverEntity((Entity)entity);
                continue;
            }
            double speed = 0.06;
            double distScale = 1.0 - Math.min(0.9, distance / (double)rangeSqr);
            distScale *= distScale;
            entity.motionX += x / distance * distScale * speed;
            entity.motionY += y / distance * distScale * 0.2;
            entity.motionZ += z / distance * distScale * speed;
        }
    }

    private void hooverEntity(Entity entity) {
        if (!this.worldObj.isRemote && entity instanceof EntityItem && !entity.isDead) {
            EntityItem item = (EntityItem)entity;
            ItemStack stack = item.getEntityItem().copy();
            int numInserted = ItemUtil.doInsertItem((Object)this, (ItemStack)stack, null);
            stack.stackSize -= numInserted;
            item.setEntityItemStack(stack);
            if (stack.stackSize == 0) {
                item.setDead();
            }
        }
    }

    private boolean isFull() {
        for (ItemStack stack : this.inv) {
            if (stack != null && stack.stackSize >= stack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public int getSizeInventory() {
        return this.inv.length;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot < 0 || slot >= this.inv.length) {
            return null;
        }
        return this.inv[slot];
    }

    public ItemStack decrStackSize(int fromSlot, int amount) {
        ItemStack fromStack = this.inv[fromSlot];
        if (fromStack == null) {
            return null;
        }
        if (fromStack.stackSize <= amount) {
            this.inv[fromSlot] = null;
            return fromStack;
        }
        ItemStack result = new ItemStack(fromStack.getItem(), amount, fromStack.getItemDamage());
        if (fromStack.stackTagCompound != null) {
            result.stackTagCompound = (NBTTagCompound)fromStack.stackTagCompound.copy();
        }
        fromStack.stackSize -= amount;
        return result;
    }

    public void setInventorySlotContents(int slot, ItemStack contents) {
        if (slot < 0 || slot >= this.inv.length) {
            System.out.println("TileVacumChest.setInventorySlotContents: " + slot);
            return;
        }
        this.inv[slot] = contents == null ? contents : contents.copy();
        if (contents != null && contents.stackSize > this.getInventoryStackLimit()) {
            contents.stackSize = this.getInventoryStackLimit();
        }
    }

    public ItemStack getStackInSlotOnClosing(int var1) {
        return null;
    }

    public String getInventoryName() {
        return ModObject.blockVacuumChest.unlocalisedName;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int var1, ItemStack var2) {
        return true;
    }

    public boolean isItemValidForFilter(ItemStack itemstack) {
        return itemstack != null && itemstack.getItem() == EnderIO.itemBasicFilterUpgrade && itemstack.getItemDamage() == 0;
    }

    public int getRange() {
        return this.range;
    }

    private int limitRange(int range) {
        return Math.max(1, Math.min(Config.vacuumChestRange, range));
    }

    public void setRange(int range) {
        this.range = this.limitRange(range);
        this.updateBlock();
    }

    public ItemStack getFilterItem() {
        return this.filterItem;
    }

    public void setFilterItem(ItemStack filterItem) {
        IItemFilter newFilter = FilterRegister.getFilterForUpgrade(filterItem);
        if (newFilter == null || newFilter instanceof ItemFilter) {
            this.filterItem = filterItem;
            this.filter = (ItemFilter)newFilter;
            this.updateBlock();
        }
    }

    public void setFilterBlacklist(boolean isBlacklist) {
        if (this.filter != null) {
            this.filter.setBlacklist(isBlacklist);
            this.updateFilterItem();
        }
    }

    public void setFilterMatchMeta(boolean matchMeta) {
        if (this.filter != null) {
            this.filter.setMatchMeta(matchMeta);
            this.updateFilterItem();
        }
    }

    public boolean hasItemFilter() {
        return this.filter != null;
    }

    public ItemFilter getItemFilter() {
        return this.filter;
    }

    public void setItemFilterSlot(int slot, ItemStack stack) {
        if (slot >= 0 && slot < 5 && this.filter != null) {
            this.filter.setInventorySlotContents(slot, stack);
            this.updateFilterItem();
        }
    }

    private void updateFilterItem() {
        FilterRegister.writeFilterToStack(this.filter, this.filterItem);
        this.updateBlock();
    }

    @Override
    public RedstoneControlMode getRedstoneControlMode() {
        return this.redstoneControlMode;
    }

    @Override
    public void setRedstoneControlMode(RedstoneControlMode redstoneControlMode) {
        this.redstoneControlMode = redstoneControlMode;
        this.redstoneStateDirty = true;
        this.updateBlock();
    }

    public void readCustomNBT(NBTTagCompound nbtRoot) {
        this.readContentsFromNBT(nbtRoot);
        this.redstoneCheckPassed = nbtRoot.getBoolean("redstoneCheckPassed");
    }

    public void readContentsFromNBT(NBTTagCompound nbtRoot) {
        NBTTagList itemList = (NBTTagList)nbtRoot.getTag("Items");
        if (itemList != null) {
            for (int i = 0; i < itemList.tagCount(); ++i) {
                NBTTagCompound itemStack = itemList.getCompoundTagAt(i);
                byte slot = itemStack.getByte("Slot");
                if (slot < 0 || slot >= this.inv.length) continue;
                this.inv[slot] = ItemStack.loadItemStackFromNBT((NBTTagCompound)itemStack);
            }
        }
        this.range = nbtRoot.hasKey("range") ? this.limitRange(nbtRoot.getInteger("range")) : Config.vacuumChestRange;
        if (nbtRoot.hasKey("filter")) {
            NBTTagCompound filterTag = (NBTTagCompound)nbtRoot.getTag("filter");
            this.filterItem = ItemStack.loadItemStackFromNBT((NBTTagCompound)filterTag);
            IItemFilter flt = FilterRegister.getFilterForUpgrade(this.filterItem);
            if (flt instanceof ItemFilter) {
                this.filter = (ItemFilter)flt;
            } else {
                this.filterItem = null;
            }
        } else {
            this.filterItem = null;
            this.filter = null;
        }
        int rsContr = nbtRoot.getInteger("redstoneControlMode");
        if (rsContr < 0 || rsContr >= RedstoneControlMode.values().length) {
            rsContr = 0;
        }
        this.redstoneControlMode = RedstoneControlMode.values()[rsContr];
    }

    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        this.writeContentsToNBT(nbtRoot);
        nbtRoot.setBoolean("redstoneCheckPassed", this.redstoneCheckPassed);
    }

    public void writeContentsToNBT(NBTTagCompound nbtRoot) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound itemStackNBT = new NBTTagCompound();
            itemStackNBT.setByte("Slot", (byte)i);
            this.inv[i].writeToNBT(itemStackNBT);
            itemList.appendTag((NBTBase)itemStackNBT);
        }
        nbtRoot.setTag("Items", (NBTBase)itemList);
        nbtRoot.setInteger("range", this.range);
        if (this.filterItem != null) {
            NBTTagCompound filterNBT = new NBTTagCompound();
            this.filterItem.writeToNBT(filterNBT);
            nbtRoot.setTag("filter", (NBTBase)filterNBT);
        }
        nbtRoot.setInteger("redstoneControlMode", this.redstoneControlMode.ordinal());
    }
}

