/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vacuum;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.TileEntityEnder;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import crazypants.enderio.machine.vacuum.ContainerVacuumChest;
import crazypants.enderio.machine.vacuum.GuiVacuumChest;
import crazypants.enderio.machine.vacuum.PacketVaccumChest;
import crazypants.enderio.machine.vacuum.TileVacuumChest;
import crazypants.enderio.network.PacketHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockVacuumChest
extends BlockEio
implements IGuiHandler,
IResourceTooltipProvider,
IRedstoneConnectable {
    public static int renderId;

    public static BlockVacuumChest create() {
        PacketHandler.INSTANCE.registerMessage(PacketVaccumChest.class, PacketVaccumChest.class, PacketHandler.nextID(), Side.SERVER);
        BlockVacuumChest res = new BlockVacuumChest();
        res.init();
        return res;
    }

    protected BlockVacuumChest() {
        super(ModObject.blockVacuumChest.unlocalisedName, TileVacuumChest.class);
        this.setBlockTextureName("enderio:blockVacuumChest");
    }

    @Override
    public boolean shouldRedstoneConduitConnect(World world, int x, int y, int z, ForgeDirection from) {
        return true;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block blockId) {
        TileEntity ent = world.getTileEntity(x, y, z);
        if (ent instanceof TileVacuumChest) {
            ((TileVacuumChest)ent).onNeighborBlockChange(blockId);
        }
    }

    protected void init() {
        super.init();
        EnderIO.guiHandler.registerGuiHandler(89, this);
    }

    protected boolean openGui(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        if (!world.isRemote) {
            entityPlayer.openGui((Object)EnderIO.instance, 89, world, x, y, z);
        }
        return true;
    }

    public boolean doNormalDrops(World world, int x, int y, int z) {
        return false;
    }

    protected void processDrop(World world, int x, int y, int z, TileEntityEnder te, ItemStack drop) {
        drop.stackTagCompound = new NBTTagCompound();
        if (te != null) {
            ((TileVacuumChest)te).writeContentsToNBT(drop.stackTagCompound);
        }
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase placedBy, ItemStack stack) {
        if (!world.isRemote) {
            TileEntity te = world.getTileEntity(x, y, z);
            if (stack != null && stack.stackTagCompound != null && te instanceof TileVacuumChest) {
                ((TileVacuumChest)te).readContentsFromNBT(stack.stackTagCompound);
                world.markBlockForUpdate(x, y, z);
            }
        }
    }

    public int getRenderType() {
        return renderId;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileVacuumChest) {
            return new ContainerVacuumChest(player, player.inventory, (TileVacuumChest)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileVacuumChest) {
            return new GuiVacuumChest(player, player.inventory, (TileVacuumChest)te);
        }
        return null;
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.getUnlocalizedName();
    }
}

