/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.client.gui.button.MultiIconButton;
import com.enderio.core.client.render.ColorUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.gui.item.BasicItemFilterGui;
import crazypants.enderio.conduit.gui.item.IItemFilterContainer;
import crazypants.enderio.conduit.item.filter.ItemFilter;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.transceiver.PacketItemFilter;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import crazypants.enderio.machine.transceiver.gui.ContainerTransceiver;
import crazypants.enderio.machine.transceiver.gui.GuiTransceiver;
import crazypants.enderio.network.PacketHandler;
import java.awt.Color;
import java.awt.Point;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class FilterTab
implements ITabPanel {
    private final GuiTransceiver parent;
    private final ContainerTransceiver container;
    private final BasicItemFilterGui sendGui;
    private final BasicItemFilterGui recGui;
    private final MultiIconButton sendRecB;
    boolean showSend = true;

    FilterTab(GuiTransceiver parent) {
        this.parent = parent;
        this.container = parent.getContainer();
        this.sendGui = new BasicItemFilterGui(parent, new FilterContainer(parent.getTransciever(), true), false, this.container.getFilterOffset().x, this.container.getFilterOffset().y, 0);
        this.recGui = new BasicItemFilterGui(parent, new FilterContainer(parent.getTransciever(), false), false, this.container.getFilterOffset().x, this.container.getFilterOffset().y, 20);
        this.sendRecB = MultiIconButton.createRightArrowButton((IGuiScreen)parent, (int)8888, (int)(this.container.getFilterOffset().x + 79), (int)(this.container.getFilterOffset().y - 20));
        this.sendRecB.setSize(10, 16);
    }

    public void onGuiInit(int x, int y, int width, int height) {
        this.parent.getContainer().setPlayerInventoryVisible(true);
        this.sendRecB.onGuiInit();
        this.updateSendRecieve();
    }

    protected void updateSendRecieve() {
        this.parent.getGhostSlots().clear();
        if (this.showSend) {
            this.sendGui.updateButtons();
            this.recGui.deactivate();
            this.sendGui.createFilterSlots();
        } else {
            this.sendGui.deactivate();
            this.recGui.updateButtons();
            this.recGui.createFilterSlots();
        }
    }

    public void deactivate() {
        this.parent.getContainer().setPlayerInventoryVisible(false);
        this.sendGui.deactivate();
        this.recGui.deactivate();
        this.sendRecB.detach();
    }

    public IconEIO getIcon() {
        return IconEIO.FILTER;
    }

    public void render(float par1, int par2, int par3) {
        int top = this.parent.getGuiTop();
        int left = this.parent.getGuiLeft();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.parent.bindGuiTexture();
        Point invRoot = this.container.getPlayerInventoryOffset();
        this.parent.drawTexturedModalRect(left + invRoot.x - 1, top + invRoot.y - 1, 24, 180, 162, 76);
        if (this.showSend) {
            this.sendGui.renderCustomOptions(0, par1, par2, par3);
        } else {
            this.recGui.renderCustomOptions(0, par1, par2, par3);
        }
        String txt = EnderIO.lang.localize("gui.machine.sendfilter");
        if (!this.showSend) {
            txt = EnderIO.lang.localize("gui.machine.receivefilter");
        }
        FontRenderer fr = this.parent.getFontRenderer();
        int x = left + this.container.getFilterOffset().x;
        int y = top - fr.FONT_HEIGHT + this.container.getFilterOffset().y - 7;
        fr.drawStringWithShadow(txt, x, y, ColorUtil.getRGB((Color)Color.WHITE));
    }

    public void actionPerformed(GuiButton guiButton) {
        if (guiButton == this.sendRecB) {
            this.showSend = !this.showSend;
            this.updateSendRecieve();
        }
        if (this.showSend) {
            this.sendGui.actionPerformed(guiButton);
        } else {
            this.recGui.actionPerformed(guiButton);
        }
    }

    public void mouseClicked(int x, int y, int par3) {
        if (this.showSend) {
            this.sendGui.mouseClicked(x, y, par3);
        } else {
            this.recGui.mouseClicked(x, y, par3);
        }
    }

    public void keyTyped(char par1, int par2) {
    }

    public void updateScreen() {
    }

    private static class FilterContainer
    implements IItemFilterContainer {
        private final TileTransceiver trans;
        private final boolean isSend;

        private FilterContainer(TileTransceiver trans, boolean isSend) {
            this.trans = trans;
            this.isSend = isSend;
        }

        @Override
        public ItemFilter getItemFilter() {
            if (this.isSend) {
                return this.trans.getSendItemFilter();
            }
            return this.trans.getReceiveItemFilter();
        }

        @Override
        public void onFilterChanged() {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketItemFilter(this.trans, this.isSend));
        }
    }
}

