/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.ItemUtil;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.item.FilterRegister;
import crazypants.enderio.conduit.item.filter.ItemFilter;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.ContinuousTask;
import crazypants.enderio.machine.IItemBuffer;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.transceiver.Channel;
import crazypants.enderio.machine.transceiver.ChannelType;
import crazypants.enderio.machine.transceiver.PacketSendRecieveChannelList;
import crazypants.enderio.machine.transceiver.ServerChannelRegister;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.ICapacitor;
import crazypants.enderio.power.IInternalPowerHandler;
import crazypants.enderio.power.PowerDistributor;
import crazypants.enderio.rail.EnderRailController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileTransceiver
extends AbstractPoweredTaskEntity
implements IFluidHandler,
IItemBuffer,
IInternalPowerHandler {
    private static final float MIN_POWER_TO_SEND = 0.5f;
    private final SetMultimap<ChannelType, Channel> sendChannels = MultimapBuilder.enumKeys(ChannelType.class).hashSetValues().build();
    private final SetMultimap<ChannelType, Channel> recieveChannels = MultimapBuilder.enumKeys(ChannelType.class).hashSetValues().build();
    private ICapacitor capacitor = new BasicCapacitor(Config.transceiverMaxIoRF * 2, 500000, Config.transceiverMaxIoRF);
    private boolean sendChannelsDirty = false;
    private boolean recieveChannelsDirty = false;
    private boolean registered = false;
    private Map<ForgeDirection, IFluidHandler> neighbourFluidHandlers = null;
    private PowerDistributor powerDistributor;
    private final EnderRailController railController;
    private boolean inFluidFill = false;
    private boolean inGetTankInfo = false;
    private ItemFilter sendItemFilter;
    private ItemFilter recieveItemFilter;
    private boolean bufferStacks = true;

    public TileTransceiver() {
        super(new SlotDefinition(8, 8, 0));
        this.currentTask = new ContinuousTask(Config.transceiverUpkeepCostRF);
        this.railController = new EnderRailController(this);
        this.sendItemFilter = new ItemFilter(true);
        this.recieveItemFilter = new ItemFilter(true);
    }

    public EnderRailController getRailController() {
        return this.railController;
    }

    public boolean isRedstoneChecksPassed() {
        return this.redstoneCheckPassed;
    }

    @Override
    protected boolean processTasks(boolean redstoneChecksPassed) {
        boolean res = super.processTasks(redstoneChecksPassed);
        if (!redstoneChecksPassed) {
            return res;
        }
        this.processPower();
        this.processItems();
        return res;
    }

    @Override
    public void doUpdate() {
        if (!this.registered && !this.worldObj.isRemote) {
            ServerChannelRegister.instance.register(this);
            this.registered = true;
            this.removeUnregsiteredChannels(this.sendChannels);
            this.removeUnregsiteredChannels(this.recieveChannels);
        }
        super.doUpdate();
        if (!this.worldObj.isRemote) {
            this.railController.doTick();
            if (this.sendChannelsDirty) {
                PacketHandler.sendToAllAround((IMessage)new PacketSendRecieveChannelList(this, true), (TileEntity)this, 256);
                this.sendChannelsDirty = false;
            }
            if (this.recieveChannelsDirty) {
                PacketHandler.sendToAllAround((IMessage)new PacketSendRecieveChannelList(this, false), (TileEntity)this, 256);
                this.recieveChannelsDirty = false;
            }
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.registered && this.worldObj != null && !this.worldObj.isRemote) {
            ServerChannelRegister.instance.dergister(this);
            this.registered = false;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.registered && this.worldObj != null && !this.worldObj.isRemote) {
            ServerChannelRegister.instance.dergister(this);
            this.registered = false;
        }
    }

    private void removeUnregsiteredChannels(SetMultimap<ChannelType, Channel> chans) {
        ArrayList<Channel> toRemove = new ArrayList<Channel>();
        for (Channel chan : chans.values()) {
            if (ServerChannelRegister.instance.getChannelsForType(chan.getType()).contains(chan)) continue;
            toRemove.add(chan);
        }
        for (Channel chan : toRemove) {
            this.removeChannel(chan, chans);
        }
    }

    @Override
    public String getMachineName() {
        return ModObject.blockTransceiver.unlocalisedName;
    }

    @Override
    public boolean isActive() {
        return this.hasPower();
    }

    @Override
    public ICapacitor getCapacitor() {
        return this.capacitor;
    }

    @Override
    public int getPowerUsePerTick() {
        return Config.transceiverUpkeepCostRF;
    }

    public Set<Channel> getSendChannels(ChannelType type) {
        return this.sendChannels.get((Object)type);
    }

    public Set<Channel> getRecieveChannels(ChannelType type) {
        return this.recieveChannels.get((Object)type);
    }

    public void addSendChanel(Channel channel) {
        this.addChannel(channel, this.sendChannels);
    }

    public void addRecieveChanel(Channel channel) {
        this.addChannel(channel, this.recieveChannels);
    }

    public void removeSendChanel(Channel channel) {
        this.removeChannel(channel, this.sendChannels);
    }

    public void removeRecieveChanel(Channel channel) {
        this.removeChannel(channel, this.recieveChannels);
    }

    private void addChannel(Channel channel, SetMultimap<ChannelType, Channel> channels) {
        if (channel == null) {
            return;
        }
        Set chans = channels.get((Object)channel.getType());
        if (chans.add(channel)) {
            if (channels == this.sendChannels) {
                this.sendChannelsDirty = true;
            } else {
                this.recieveChannelsDirty = true;
            }
        }
    }

    private void removeChannel(Channel channel, SetMultimap<ChannelType, Channel> channnels) {
        if (channel == null) {
            return;
        }
        Set chans = channnels.get((Object)channel.getType());
        if (chans.remove(channel)) {
            if (channnels == this.sendChannels) {
                this.sendChannelsDirty = true;
            } else {
                this.recieveChannelsDirty = true;
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        super.readCustomNBT(nbtRoot);
        this.railController.readFromNBT(nbtRoot);
        this.currentTask = new ContinuousTask(Config.transceiverUpkeepCostRF);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        super.writeCustomNBT(nbtRoot);
        this.railController.writeToNBT(nbtRoot);
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        NBTTagCompound itemRoot;
        super.readCommon(nbtRoot);
        TileTransceiver.readChannels(nbtRoot, this.sendChannels, "sendChannels");
        TileTransceiver.readChannels(nbtRoot, this.recieveChannels, "recieveChannels");
        if (nbtRoot.hasKey("sendItemFilter")) {
            itemRoot = nbtRoot.getCompoundTag("sendItemFilter");
            this.sendItemFilter.copyFrom((ItemFilter)FilterRegister.loadFilterFromNbt(itemRoot));
        }
        if (nbtRoot.hasKey("recieveItemFilter")) {
            itemRoot = nbtRoot.getCompoundTag("recieveItemFilter");
            this.recieveItemFilter.copyFrom((ItemFilter)FilterRegister.loadFilterFromNbt(itemRoot));
        }
        this.bufferStacks = nbtRoot.hasKey("bufferStacks") ? nbtRoot.getBoolean("bufferStacks") : true;
    }

    static void readChannels(NBTTagCompound nbtRoot, SetMultimap<ChannelType, Channel> channels, String key) {
        channels.clear();
        if (!nbtRoot.hasKey(key)) {
            return;
        }
        NBTTagList tags = (NBTTagList)nbtRoot.getTag(key);
        for (int i = 0; i < tags.tagCount(); ++i) {
            NBTTagCompound chanelTag = tags.getCompoundTagAt(i);
            Channel channel = Channel.readFromNBT(chanelTag);
            if (channel == null) continue;
            channels.put((Object)channel.getType(), (Object)channel);
        }
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        NBTTagCompound itemRoot;
        super.writeCommon(nbtRoot);
        NBTTagList channelTags = TileTransceiver.createTagList(this.sendChannels);
        nbtRoot.setTag("sendChannels", (NBTBase)channelTags);
        channelTags = TileTransceiver.createTagList(this.recieveChannels);
        nbtRoot.setTag("recieveChannels", (NBTBase)channelTags);
        if (this.sendItemFilter != null) {
            itemRoot = new NBTTagCompound();
            FilterRegister.writeFilterToNbt(this.sendItemFilter, itemRoot);
            nbtRoot.setTag("sendItemFilter", (NBTBase)itemRoot);
        }
        if (this.recieveItemFilter != null) {
            itemRoot = new NBTTagCompound();
            FilterRegister.writeFilterToNbt(this.recieveItemFilter, itemRoot);
            nbtRoot.setTag("recieveItemFilter", (NBTBase)itemRoot);
        }
        nbtRoot.setBoolean("bufferStacks", this.bufferStacks);
    }

    static NBTTagList createTagList(SetMultimap<ChannelType, Channel> channels) {
        NBTTagList res = new NBTTagList();
        for (Channel channel : channels.values()) {
            NBTTagCompound chanTag = new NBTTagCompound();
            channel.writeToNBT(chanTag);
            res.appendTag((NBTBase)chanTag);
        }
        return res;
    }

    void setSendChannels(Multimap<? extends ChannelType, ? extends Channel> channels) {
        this.sendChannels.clear();
        this.sendChannels.putAll(channels);
    }

    void setRecieveChannels(Multimap<? extends ChannelType, ? extends Channel> channels) {
        this.recieveChannels.clear();
        this.recieveChannels.putAll(channels);
    }

    SetMultimap<ChannelType, Channel> getSendChannels() {
        return this.sendChannels;
    }

    SetMultimap<ChannelType, Channel> getReceiveChannels() {
        return this.recieveChannels;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    private void processPower() {
        Set<Channel> sendTo = this.getSendChannels(ChannelType.POWER);
        int canSend = this.getMaxSendableEnergy();
        if (canSend > 0 && !sendTo.isEmpty()) {
            Iterator<Channel> iter = sendTo.iterator();
            while (canSend > 0 && iter.hasNext()) {
                ServerChannelRegister.instance.sendPower(this, canSend, iter.next());
                canSend = this.getMaxSendableEnergy();
            }
        }
        if ((canSend = this.getMaxSendableEnergy()) > 0 && !this.getRecieveChannels(ChannelType.POWER).isEmpty()) {
            if (this.powerDistributor == null) {
                this.powerDistributor = new PowerDistributor(this.getLocation());
            }
            int used = this.powerDistributor.transmitEnergy(this.worldObj, canSend);
            this.usePower(used);
        }
    }

    private int getMaxSendableEnergy() {
        return this.getEnergyStored() - (int)(0.5f * (float)this.getMaxEnergyStored());
    }

    private float getEnergyStoredRatio() {
        return (float)this.getEnergyStored() / (float)this.getMaxEnergyStored();
    }

    @Override
    public void onNeighborBlockChange(Block blockId) {
        super.onNeighborBlockChange(blockId);
        if (this.powerDistributor != null) {
            this.powerDistributor.neighboursChanged();
        }
        this.neighbourFluidHandlers = null;
    }

    private boolean hasRecieveChannel(Set<Channel> channels, ChannelType type) {
        boolean hasChannel = false;
        for (Channel chan : channels) {
            if (!this.getRecieveChannels(type).contains(chan)) continue;
            hasChannel = true;
            break;
        }
        return hasChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this.inFluidFill) {
            return false;
        }
        try {
            this.inFluidFill = true;
            if (this.getSendChannels(ChannelType.FLUID).isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = ServerChannelRegister.instance.canFill(this, this.getSendChannels(ChannelType.FLUID), fluid);
            return bl;
        }
        finally {
            this.inFluidFill = false;
        }
    }

    public boolean canReceive(Set<Channel> channels, Fluid fluid) {
        if (this.inFluidFill) {
            return false;
        }
        if (!this.hasRecieveChannel(channels, ChannelType.FLUID)) {
            return false;
        }
        Map<ForgeDirection, IFluidHandler> handlers = this.getNeighbouringFluidHandlers();
        for (Map.Entry<ForgeDirection, IFluidHandler> entry : handlers.entrySet()) {
            if (!entry.getValue().canFill(entry.getKey().getOpposite(), fluid)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.inFluidFill) {
            return 0;
        }
        try {
            this.inFluidFill = true;
            if (this.getSendChannels(ChannelType.FLUID).isEmpty() || !this.redstoneCheckPassed || !this.getIoMode(from).canRecieveInput()) {
                int n = 0;
                return n;
            }
            int n = ServerChannelRegister.instance.fill(this, this.getSendChannels(ChannelType.FLUID), resource, doFill);
            return n;
        }
        finally {
            this.inFluidFill = false;
        }
    }

    public int recieveFluid(Set<Channel> channels, FluidStack resource, boolean doFill) {
        if (this.inFluidFill) {
            return 0;
        }
        if (!this.hasRecieveChannel(channels, ChannelType.FLUID) || !this.redstoneCheckPassed) {
            return 0;
        }
        Map<ForgeDirection, IFluidHandler> handlers = this.getNeighbouringFluidHandlers();
        for (Map.Entry<ForgeDirection, IFluidHandler> entry : handlers.entrySet()) {
            int res;
            IoMode mode = this.getIoMode(entry.getKey());
            if (!mode.canOutput() || (res = entry.getValue().fill(entry.getKey().getOpposite(), resource, doFill)) <= 0) continue;
            return res;
        }
        return 0;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.inGetTankInfo) {
            return new FluidTankInfo[0];
        }
        try {
            this.inGetTankInfo = true;
            FluidTankInfo[] fluidTankInfoArray = ServerChannelRegister.instance.getTankInfoForChannels(this, this.getSendChannels(ChannelType.FLUID));
            return fluidTankInfoArray;
        }
        finally {
            this.inGetTankInfo = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRecieveTankInfo(List<FluidTankInfo> infos, Set<Channel> channels) {
        if (this.inGetTankInfo) {
            return;
        }
        try {
            this.inGetTankInfo = true;
            if (!this.hasRecieveChannel(channels, ChannelType.FLUID)) {
                return;
            }
            Map<ForgeDirection, IFluidHandler> fluidHandlers = this.getNeighbouringFluidHandlers();
            for (Map.Entry<ForgeDirection, IFluidHandler> entry : fluidHandlers.entrySet()) {
                FluidTankInfo[] tanks = entry.getValue().getTankInfo(entry.getKey().getOpposite());
                if (tanks == null) continue;
                for (FluidTankInfo info : tanks) {
                    infos.add(info);
                }
            }
        }
        finally {
            this.inGetTankInfo = false;
        }
    }

    Map<ForgeDirection, IFluidHandler> getNeighbouringFluidHandlers() {
        if (this.neighbourFluidHandlers == null) {
            this.neighbourFluidHandlers = FluidUtil.getNeighbouringFluidHandlers((IBlockAccess)this.worldObj, (BlockCoord)this.getLocation());
        }
        return this.neighbourFluidHandlers;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    @Override
    public int getInventoryStackLimit() {
        return this.bufferStacks ? 64 : 1;
    }

    @Override
    public boolean isBufferStacks() {
        return this.bufferStacks;
    }

    @Override
    public void setBufferStacks(boolean bufferStacks) {
        this.bufferStacks = bufferStacks;
    }

    private void processItems() {
        Set<Channel> sendItemChannels = this.getSendChannels(ChannelType.ITEM);
        if (!sendItemChannels.isEmpty()) {
            for (int i = this.slotDefinition.minInputSlot; i <= this.slotDefinition.maxInputSlot; ++i) {
                ItemStack toSend = this.getStackInSlot(i);
                if (toSend == null) continue;
                ServerChannelRegister.instance.sendItem(this, sendItemChannels, i, toSend);
            }
        }
    }

    public ItemFilter getSendItemFilter() {
        return this.sendItemFilter;
    }

    public ItemFilter getReceiveItemFilter() {
        return this.recieveItemFilter;
    }

    public ItemFilter getRecieveItemFilter() {
        return this.recieveItemFilter;
    }

    public void setRecieveItemFilter(ItemFilter recieveItemFilter) {
        this.recieveItemFilter = recieveItemFilter;
    }

    public void setSendItemFilter(ItemFilter sendItemFilter) {
        this.sendItemFilter = sendItemFilter;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int slot, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return !(this.slotDefinition.isInputSlot(slot) ? !this.getSendItemFilter().doesItemPassFilter(null, itemstack) : this.slotDefinition.isOutputSlot(slot) && !this.getReceiveItemFilter().doesItemPassFilter(null, itemstack));
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemstack, int j) {
        block7: {
            block6: {
                if (itemstack == null) {
                    return false;
                }
                if (!this.slotDefinition.isInputSlot(slot)) break block6;
                Set chans = this.getSendChannels().get((Object)ChannelType.ITEM);
                if (chans == null || chans.size() == 0) {
                    return false;
                }
                if (!this.getSendItemFilter().doesItemPassFilter(null, itemstack)) {
                    return false;
                }
                for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
                    if (i == slot || !ItemUtil.areStacksEqual((ItemStack)itemstack, (ItemStack)this.getStackInSlot(i))) continue;
                    return false;
                }
                break block7;
            }
            if (!this.slotDefinition.isOutputSlot(slot)) break block7;
            if (!this.getRecieveItemFilter().doesItemPassFilter(null, itemstack)) {
                return false;
            }
            for (int i = this.slotDefinition.getMinOutputSlot(); i <= this.slotDefinition.getMaxOutputSlot(); ++i) {
                if (i == slot || !ItemUtil.areStacksEqual((ItemStack)itemstack, (ItemStack)this.getStackInSlot(i))) continue;
                return false;
            }
        }
        return super.canInsertItem(slot, itemstack, j);
    }
}

