/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.tank;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.tank.GuiTank;
import crazypants.enderio.machine.tank.PacketTankFluid;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.tool.ArrayMappingTool;
import crazypants.enderio.tool.SmartTank;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileTank
extends AbstractMachineEntity
implements IFluidHandler,
ITankAccess {
    private static int IO_MB_TICK = 100;
    protected SmartTank tank;
    protected int lastUpdateLevel = -1;
    private boolean tankDirty = false;
    private Fluid lastFluid = null;
    private GuiTank.VoidMode voidMode = GuiTank.VoidMode.NEVER;

    public TileTank(int meta) {
        super(new SlotDefinition(0, 2, 3, 4, -1, -1));
        this.tank = meta == 1 ? new SmartTank(32000) : new SmartTank(16000);
    }

    public TileTank() {
        this(0);
    }

    @Override
    protected boolean doPush(ForgeDirection dir) {
        BlockCoord loc;
        IFluidHandler target;
        if (this.isSideDisabled(dir.ordinal())) {
            return false;
        }
        boolean res = super.doPush(dir);
        if (this.tank.getFluidAmount() > 0 && (target = FluidUtil.getFluidHandler((IBlockAccess)this.worldObj, (BlockCoord)(loc = this.getLocation().getLocation(dir)))) != null && target.canFill(dir.getOpposite(), this.tank.getFluid().getFluid())) {
            FluidStack push = this.tank.getFluid().copy();
            push.amount = Math.min(push.amount, IO_MB_TICK);
            int filled = target.fill(dir.getOpposite(), push, true);
            if (filled > 0) {
                this.tank.drain(filled, true);
                this.tankDirty = true;
                return res;
            }
        }
        return res;
    }

    @Override
    protected boolean doPull(ForgeDirection dir) {
        BlockCoord loc;
        IFluidHandler target;
        if (this.isSideDisabled(dir.ordinal())) {
            return false;
        }
        boolean res = super.doPull(dir);
        if (this.tank.getFluidAmount() < this.tank.getCapacity() && (target = FluidUtil.getFluidHandler((IBlockAccess)this.worldObj, (BlockCoord)(loc = this.getLocation().getLocation(dir)))) != null) {
            if (this.tank.getFluidAmount() > 0) {
                FluidStack canPull = this.tank.getFluid().copy();
                canPull.amount = this.tank.getCapacity() - this.tank.getFluidAmount();
                canPull.amount = Math.min(canPull.amount, IO_MB_TICK);
                FluidStack drained = target.drain(dir.getOpposite(), canPull, true);
                if (drained != null && drained.amount > 0) {
                    this.tank.fill(drained, true);
                    this.tankDirty = true;
                    return res;
                }
            } else {
                FluidTankInfo[] infos = target.getTankInfo(dir.getOpposite());
                if (infos != null) {
                    for (FluidTankInfo info : infos) {
                        if (info.fluid == null || info.fluid.amount <= 0 || !this.canFill(dir, info.fluid.getFluid())) continue;
                        FluidStack canPull = info.fluid.copy();
                        canPull.amount = Math.min(IO_MB_TICK, canPull.amount);
                        FluidStack drained = target.drain(dir.getOpposite(), canPull, true);
                        if (drained == null || drained.amount <= 0) continue;
                        this.tank.fill(drained, true);
                        this.tankDirty = true;
                        return res;
                    }
                }
            }
        }
        return res;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from)) {
            return 0;
        }
        return this.fillInternal(resource, doFill);
    }

    int fillInternal(FluidStack resource, boolean doFill) {
        int res = this.tank.fill(resource, doFill);
        if (res > 0 && doFill) {
            this.tankDirty = true;
        }
        return res;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.canDrain(from)) {
            return null;
        }
        return this.drainInternal(resource, doDrain);
    }

    FluidStack drainInternal(FluidStack resource, boolean doDrain) {
        FluidStack res = this.tank.drain(resource, doDrain);
        if (res != null && res.amount > 0 && doDrain) {
            this.tankDirty = true;
        }
        return res;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.canDrain(from)) {
            return null;
        }
        return this.drainInternal(maxDrain, doDrain);
    }

    FluidStack drainInternal(int maxDrain, boolean doDrain) {
        FluidStack res = this.tank.drain(maxDrain, doDrain);
        if (res != null && res.amount > 0 && doDrain) {
            this.tankDirty = true;
        }
        return res;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.canFill(from) && fluid != null && (this.tank.getFluidAmount() > 0 && this.tank.getFluid().getFluidID() == fluid.getID() || this.tank.getFluidAmount() == 0);
    }

    private boolean canFill(ForgeDirection from) {
        IoMode mode = this.getIoMode(from);
        return mode != IoMode.PUSH && mode != IoMode.DISABLED;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.canDrain(from) && this.tank.canDrainFluidType(fluid);
    }

    private boolean canDrain(ForgeDirection from) {
        IoMode mode = this.getIoMode(from);
        return mode != IoMode.PULL && mode != IoMode.DISABLED;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.tank)};
    }

    private int getFilledLevel() {
        int level = (int)Math.floor(16.0f * this.tank.getFilledRatio());
        if (level == 0 && this.tank.getFluidAmount() > 0) {
            level = 1;
        }
        return level;
    }

    public boolean canVoidItems() {
        return this.tank.getFluid() != null && this.tank.getFluid().getFluid().getTemperature() > 973;
    }

    public GuiTank.VoidMode getVoidMode() {
        return this.voidMode;
    }

    public void setVoidMode(GuiTank.VoidMode mode) {
        this.voidMode = mode;
    }

    @Override
    public String getMachineName() {
        return "tank";
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack item) {
        if (this.canVoidItems() && this.voidMode == GuiTank.VoidMode.ALWAYS && i < this.getSlotDefinition().getMaxInputSlot()) {
            return false;
        }
        if (i == 0) {
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)item);
            if (fluid != null) {
                return true;
            }
            if (item.getItem() == Items.water_bucket) {
                return true;
            }
            if (item.getItem() == Items.lava_bucket) {
                return true;
            }
            return item.getItem() instanceof IFluidContainerItem && ((IFluidContainerItem)item.getItem()).getFluid(item) != null;
        }
        if (i == 1) {
            if (item.getItem() instanceof IFluidContainerItem && (((IFluidContainerItem)item.getItem()).getFluid(item) == null || ((IFluidContainerItem)item.getItem()).getFluid((ItemStack)item).amount < ((IFluidContainerItem)item.getItem()).getCapacity(item))) {
                return true;
            }
            return FluidContainerRegistry.isEmptyContainer((ItemStack)item) || item.getItem() == Items.bucket;
        }
        if (i == 2 && this.canVoidItems()) {
            return this.voidMode == GuiTank.VoidMode.ALWAYS || this.voidMode != GuiTank.VoidMode.NEVER && !FluidContainerRegistry.isContainer((ItemStack)item);
        }
        return false;
    }

    @Override
    public void setInventorySlotContents(int slot, ItemStack contents) {
        super.setInventorySlotContents(slot, contents);
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        boolean res = this.processItems(redstoneCheckPassed);
        int filledLevel = this.getFilledLevel();
        if (this.lastUpdateLevel != filledLevel) {
            this.lastUpdateLevel = filledLevel;
            this.tankDirty = false;
            return true;
        }
        if (this.tankDirty && this.shouldDoWorkThisTick(10)) {
            Fluid held;
            PacketHandler.sendToAllAround((IMessage)new PacketTankFluid(this), (TileEntity)this);
            this.worldObj.func_147453_f(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
            Fluid fluid = held = this.tank.getFluid() == null ? null : this.tank.getFluid().getFluid();
            if (this.lastFluid != held) {
                this.lastFluid = held;
                this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord, this.yCoord, this.zCoord);
            }
            this.tankDirty = false;
        }
        return res;
    }

    public int getComparatorOutput() {
        FluidTankInfo info = this.getTankInfo(null)[0];
        if (info == null || info.fluid == null) {
            return 0;
        }
        return info.fluid.amount == 0 ? 0 : (int)(1.0 + (double)info.fluid.amount / (double)info.capacity * 14.0);
    }

    private boolean processItems(boolean redstoneCheckPassed) {
        if (!redstoneCheckPassed) {
            return false;
        }
        if (!this.shouldDoWorkThisTick(20)) {
            return false;
        }
        if (this.canVoidItems()) {
            this.inventory[2] = null;
        }
        return this.drainFullContainer() || this.fillEmptyContainer();
    }

    private boolean fillEmptyContainer() {
        FluidUtil.FluidAndStackResult fill = FluidUtil.tryFillContainer((ItemStack)this.inventory[this.getSlotDefinition().getMinInputSlot() + 1], (FluidStack)this.getOutputTanks()[0].getFluid());
        if (fill.result.fluidStack == null) {
            return false;
        }
        int slot = this.getSlotDefinition().getMaxOutputSlot();
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].isStackable() && ItemUtil.areStackMergable((ItemStack)this.inventory[slot], (ItemStack)fill.result.itemStack) && this.inventory[slot].stackSize < this.inventory[slot].getMaxStackSize()) {
                fill.result.itemStack.stackSize += this.inventory[slot].stackSize;
            } else {
                return false;
            }
        }
        this.getOutputTanks()[0].setFluid(fill.remainder.fluidStack);
        this.setInventorySlotContents(this.getSlotDefinition().getMinInputSlot() + 1, fill.remainder.itemStack);
        this.setInventorySlotContents(slot, fill.result.itemStack);
        this.setTanksDirty();
        this.markDirty();
        return false;
    }

    private boolean drainFullContainer() {
        FluidUtil.FluidAndStackResult fill = FluidUtil.tryDrainContainer((ItemStack)this.inventory[this.getSlotDefinition().getMinInputSlot()], (ITankAccess)this);
        if (fill.result.fluidStack == null) {
            return false;
        }
        int slot = this.getSlotDefinition().getMinOutputSlot();
        if (this.inventory[slot] != null && fill.result.itemStack != null) {
            if (this.inventory[slot].isStackable() && ItemUtil.areStackMergable((ItemStack)this.inventory[slot], (ItemStack)fill.result.itemStack) && this.inventory[slot].stackSize < this.inventory[slot].getMaxStackSize()) {
                fill.result.itemStack.stackSize += this.inventory[slot].stackSize;
            } else {
                return false;
            }
        }
        this.getInputTank(fill.result.fluidStack).setFluid(fill.remainder.fluidStack);
        this.setInventorySlotContents(this.getSlotDefinition().getMinInputSlot(), fill.remainder.itemStack);
        if (fill.result.itemStack != null) {
            this.setInventorySlotContents(slot, fill.result.itemStack);
        }
        this.setTanksDirty();
        this.markDirty();
        return false;
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        nbtRoot.setInteger("slotLayoutVersion", 1);
        nbtRoot.setInteger("tankType", this.getBlockMetadata());
        nbtRoot.setInteger("voidMode", this.voidMode.ordinal());
        TileTank.saveTank(nbtRoot, this.tank);
    }

    public static void saveTank(NBTTagCompound nbtRoot, FluidTank tank) {
        if (tank.getFluidAmount() > 0) {
            NBTTagCompound fluidRoot = new NBTTagCompound();
            tank.getFluid().writeToNBT(fluidRoot);
            nbtRoot.setTag("tankContents", (NBTBase)fluidRoot);
        } else {
            nbtRoot.removeTag("tankContents");
        }
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        int slotLayoutVersion;
        super.readCommon(nbtRoot);
        this.tank = TileTank.loadTank(nbtRoot);
        if (nbtRoot.hasKey("voidMode")) {
            this.voidMode = GuiTank.VoidMode.values()[nbtRoot.getInteger("voidMode")];
        }
        if ((slotLayoutVersion = nbtRoot.getInteger("slotLayoutVersion")) == 0) {
            this.inventory = new ArrayMappingTool<ItemStack>("IIOO", "IIIOO").map(this.inventory);
        }
    }

    public static SmartTank loadTank(NBTTagCompound nbtRoot) {
        int tankType = nbtRoot.getInteger("tankType");
        SmartTank ret = (tankType = MathHelper.clamp_int((int)tankType, (int)0, (int)1)) == 1 ? new SmartTank(32000) : new SmartTank(16000);
        if (nbtRoot.hasKey("tankContents")) {
            FluidStack fl = FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)nbtRoot.getTag("tankContents")));
            ret.setFluid(fl);
        } else {
            ret.setFluid(null);
        }
        return ret;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        return this.tank;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.tank};
    }

    public void setTanksDirty() {
        this.tankDirty = true;
    }
}

