/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.tank;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.RenderUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.machine.tank.TileTank;
import crazypants.enderio.tool.SmartTank;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TankFluidRenderer
extends TileEntitySpecialRenderer {
    public void renderTileEntityAt(TileEntity te, double x, double y, double z, float partialTick) {
        TileTank tank = (TileTank)te;
        if (tank.tank.getFluidAmount() <= 0) {
            return;
        }
        TankFluidRenderer.renderTankFluid(tank.tank, (float)x, (float)y, (float)z);
    }

    public static void renderTankFluid(SmartTank tank, float x, float y, float z) {
        if (tank == null || tank.getFluid() == null) {
            return;
        }
        IIcon icon = tank.getFluid().getFluid().getStillIcon();
        if (icon != null) {
            float fullness = tank.getFilledRatio();
            y += 0.01f;
            float scale = 0.98f;
            float yScale = 0.98f * fullness;
            BoundingBox bb = BoundingBox.UNIT_CUBE.scale(scale, yScale, scale);
            bb = bb.translate(0.0f, -(1.0f - yScale) / 2.0f, 0.0f);
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            RenderUtil.bindBlockTexture();
            Tessellator.instance.startDrawingQuads();
            Tessellator.instance.addTranslation(x, y, z);
            CubeRenderer.render((BoundingBox)bb, (IIcon)icon);
            Tessellator.instance.addTranslation(-x, -y, -z);
            Tessellator.instance.draw();
            GL11.glPopAttrib();
        }
    }
}

