/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.tank;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.CycleButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.RenderUtil;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.gui.GuiMachineBase;
import crazypants.enderio.machine.tank.ContainerTank;
import crazypants.enderio.machine.tank.PacketTankVoidMode;
import crazypants.enderio.machine.tank.TileTank;
import crazypants.enderio.network.PacketHandler;
import java.awt.Rectangle;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;

public class GuiTank
extends GuiMachineBase<TileTank> {
    private CycleButton<VoidMode> voidBut;

    public GuiTank(InventoryPlayer par1InventoryPlayer, TileTank te) {
        super(te, (Container)new ContainerTank(par1InventoryPlayer, te), "tank");
        this.addToolTip(new GuiToolTip(new Rectangle(80, 21, 16, 47), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                String heading = EnderIO.lang.localize("tank.tank");
                if (((TileTank)((GuiTank)GuiTank.this).getTileEntity()).tank.getFluid() != null) {
                    heading = heading + ": " + ((TileTank)((GuiTank)GuiTank.this).getTileEntity()).tank.getFluid().getLocalizedName();
                }
                this.text.add(heading);
                this.text.add(Fluids.toCapactityString((IFluidTank)((TileTank)((GuiTank)GuiTank.this).getTileEntity()).tank));
            }
        });
        this.addToolTip(new GuiToolTip(new Rectangle(14, 35, 18, 18), new String[]{EnderIO.lang.localize("gui.tooltip.voidslot")}){

            public boolean shouldDraw() {
                return super.shouldDraw() && ((TileTank)GuiTank.this.getTileEntity()).canVoidItems();
            }
        });
        this.voidBut = new CycleButton((IGuiScreen)this, 123, 155, 43, VoidMode.class);
    }

    @Override
    public void initGui() {
        super.initGui();
        this.voidBut.onGuiInit();
        this.voidBut.setMode((Enum)((TileTank)this.getTileEntity()).getVoidMode());
        ((ContainerTank)this.inventorySlots).createGhostSlots(this.getGhostSlots());
    }

    public void updateScreen() {
        Slot slot = (Slot)this.inventorySlots.inventorySlots.get(2);
        if (((TileTank)this.getTileEntity()).canVoidItems()) {
            slot.xDisplayPosition = 15;
            slot.yDisplayPosition = 36;
            this.voidBut.onGuiInit();
        } else {
            slot.xDisplayPosition = 10000;
            slot.yDisplayPosition = 10000;
            this.voidBut.detach();
        }
    }

    protected void actionPerformed(GuiButton button) {
        super.actionPerformed(button);
        if (button.id == this.voidBut.id) {
            ((TileTank)this.getTileEntity()).setVoidMode((VoidMode)this.voidBut.getMode());
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTankVoidMode((TileTank)this.getTileEntity()));
        }
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.width - this.xSize) / 2;
        int sy = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(sx, sy, 0, 0, this.xSize, this.ySize);
        if (((TileTank)this.getTileEntity()).canVoidItems()) {
            Slot slot = (Slot)this.inventorySlots.inventorySlots.get(2);
            this.drawTexturedModalRect(sx + slot.xDisplayPosition - 1, sy + slot.yDisplayPosition - 1, this.xSize, 0, 18, 18);
            IconEIO.map.render((IWidgetIcon)IconEIO.MINUS, (double)(sx + slot.xDisplayPosition), (double)(sy + slot.yDisplayPosition), true);
        }
        super.drawGuiContainerBackgroundLayer(par1, par2, par3);
        RenderUtil.bindBlockTexture();
        RenderUtil.renderGuiTank((FluidTank)((TileTank)this.getTileEntity()).tank, (double)(this.guiLeft + 80), (double)(this.guiTop + 21), (double)this.zLevel, (double)16.0, (double)47.0);
    }

    public static enum VoidMode implements CycleButton.ICycleEnum
    {
        ALWAYS(IconEIO.TICK),
        IF_NOT_CONTAINER(IconEIO.ITEM_SINGLE),
        NEVER(IconEIO.CROSS);

        private final IWidgetIcon icon;
        private final List<String> unlocTooltips;

        private VoidMode(IWidgetIcon icon) {
            this.icon = icon;
            String prefix = "gui.void.mode";
            String mode = prefix + "." + this.name().toLowerCase(Locale.US);
            this.unlocTooltips = Lists.newArrayList((Object[])new String[]{prefix, mode, mode + ".desc"});
        }

        public IWidgetIcon getIcon() {
            return this.icon;
        }

        public List<String> getTooltipLines() {
            return EnderIO.lang.localizeAll(this.unlocTooltips);
        }
    }
}

