/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.spawner;

import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.PoweredTask;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.spawner.BlockPoweredSpawner;
import crazypants.enderio.machine.spawner.DummyRecipe;
import crazypants.enderio.machine.spawner.PoweredSpawnerConfig;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.Capacitors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TilePoweredSpawner
extends AbstractPoweredTaskEntity {
    public static final int MIN_SPAWN_DELAY_BASE = Config.poweredSpawnerMinDelayTicks;
    public static final int MAX_SPAWN_DELAY_BASE = Config.poweredSpawnerMaxDelayTicks;
    public static final int POWER_PER_TICK_ONE = Config.poweredSpawnerLevelOnePowerPerTickRF;
    private static final BasicCapacitor CAP_ONE = new BasicCapacitor((int)((double)POWER_PER_TICK_ONE * 1.25), Capacitors.BASIC_CAPACITOR.capacitor.getMaxEnergyStored());
    public static final int POWER_PER_TICK_TWO = Config.poweredSpawnerLevelTwoPowerPerTickRF;
    private static final BasicCapacitor CAP_TWO = new BasicCapacitor((int)((double)POWER_PER_TICK_TWO * 1.25), Capacitors.ACTIVATED_CAPACITOR.capacitor.getMaxEnergyStored());
    public static final int POWER_PER_TICK_THREE = Config.poweredSpawnerLevelThreePowerPerTickRF;
    private static final BasicCapacitor CAP_THREE = new BasicCapacitor((int)((double)POWER_PER_TICK_THREE * 1.25), Capacitors.ENDER_CAPACITOR.capacitor.getMaxEnergyStored());
    public static final int MIN_PLAYER_DISTANCE = Config.poweredSpawnerMaxPlayerDistance;
    public static final boolean USE_VANILLA_SPAWN_CHECKS = Config.poweredSpawnerUseVanillaSpawChecks;
    private static final String NULL_ENTITY_NAME = "None";
    private String entityTypeName = "None";
    private boolean isSpawnMode = true;
    private int powerUsePerTick;
    private int remainingSpawnTries;

    public TilePoweredSpawner() {
        super(new SlotDefinition(1, 1, 1));
    }

    public boolean isSpawnMode() {
        return this.isSpawnMode;
    }

    public void setSpawnMode(boolean isSpawnMode) {
        if (isSpawnMode != this.isSpawnMode) {
            this.currentTask = null;
        }
        this.isSpawnMode = isSpawnMode;
    }

    @Override
    protected void taskComplete() {
        super.taskComplete();
        if (this.isSpawnMode) {
            this.remainingSpawnTries = Config.poweredSpawnerSpawnCount + Config.poweredSpawnerMaxSpawnTries;
            for (int i = 0; i < Config.poweredSpawnerSpawnCount && this.remainingSpawnTries > 0 && this.trySpawnEntity(); ++i) {
            }
        } else {
            if (this.getStackInSlot(0) == null || this.getStackInSlot(1) != null || !this.hasEntityName()) {
                return;
            }
            ItemStack res = EnderIO.itemSoulVessel.createVesselWithEntityStub(this.getEntityName());
            this.decrStackSize(0, 1);
            this.setInventorySlotContents(1, res);
        }
    }

    @Override
    public void onCapacitorTypeChange() {
        int basePowerUse;
        BasicCapacitor refCap;
        switch (this.getCapacitorType()) {
            default: {
                refCap = CAP_ONE;
                basePowerUse = POWER_PER_TICK_ONE;
                break;
            }
            case ACTIVATED_CAPACITOR: {
                refCap = CAP_TWO;
                basePowerUse = POWER_PER_TICK_TWO;
                break;
            }
            case ENDER_CAPACITOR: {
                refCap = CAP_THREE;
                basePowerUse = POWER_PER_TICK_THREE;
            }
        }
        double multiplier = PoweredSpawnerConfig.getInstance().getCostMultiplierFor(this.getEntityName());
        this.setCapacitor(new BasicCapacitor((int)((double)refCap.getMaxEnergyExtracted() * multiplier), refCap.getMaxEnergyStored()));
        this.powerUsePerTick = (int)Math.ceil((double)basePowerUse * multiplier);
        this.forceClientUpdate = true;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockPoweredSpawner.unlocalisedName;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (itemstack == null || this.isSpawnMode) {
            return false;
        }
        if (this.slotDefinition.isInputSlot(i)) {
            return itemstack.getItem() == EnderIO.itemSoulVessel && !EnderIO.itemSoulVessel.containsSoul(itemstack);
        }
        return false;
    }

    @Override
    protected IMachineRecipe canStartNextTask(float chance) {
        if (!this.hasEntityName()) {
            return null;
        }
        if (this.isSpawnMode ? MIN_PLAYER_DISTANCE > 0 && this.worldObj.getClosestPlayer((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, (double)MIN_PLAYER_DISTANCE) == null : this.getStackInSlot(0) == null || this.getStackInSlot(1) != null) {
            return null;
        }
        return new DummyRecipe();
    }

    @Override
    protected boolean startNextTask(IMachineRecipe nextRecipe, float chance) {
        return super.startNextTask(nextRecipe, chance);
    }

    @Override
    public int getPowerUsePerTick() {
        return this.powerUsePerTick;
    }

    @Override
    protected boolean hasInputStacks() {
        return true;
    }

    @Override
    protected boolean canInsertResult(float chance, IMachineRecipe nextRecipe) {
        return true;
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        String mobType = BlockPoweredSpawner.readMobTypeFromNBT(nbtRoot);
        if (mobType == null) {
            mobType = NULL_ENTITY_NAME;
        }
        this.entityTypeName = mobType;
        this.isSpawnMode = !nbtRoot.hasKey("isSpawnMode") ? true : nbtRoot.getBoolean("isSpawnMode");
        super.readCommon(nbtRoot);
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        if (this.hasEntityName()) {
            BlockPoweredSpawner.writeMobTypeToNBT(nbtRoot, this.getEntityName());
        } else {
            BlockPoweredSpawner.writeMobTypeToNBT(nbtRoot, null);
        }
        nbtRoot.setBoolean("isSpawnMode", this.isSpawnMode);
        super.writeCommon(nbtRoot);
    }

    @Override
    protected void updateEntityClient() {
        if (this.isActive()) {
            double x = (float)this.xCoord + this.worldObj.rand.nextFloat();
            double y = (float)this.yCoord + this.worldObj.rand.nextFloat();
            double z = (float)this.zCoord + this.worldObj.rand.nextFloat();
            this.worldObj.spawnParticle("smoke", x, y, z, 0.0, 0.0, 0.0);
            this.worldObj.spawnParticle("flame", x, y, z, 0.0, 0.0, 0.0);
        }
        super.updateEntityClient();
    }

    @Override
    protected IPoweredTask createTask(IMachineRecipe nextRecipe, float chance) {
        PoweredTask res = new PoweredTask(nextRecipe, chance, this.getRecipeInputs());
        int ticksDelay = this.isSpawnMode ? MIN_SPAWN_DELAY_BASE + (int)Math.round((double)(MAX_SPAWN_DELAY_BASE - MIN_SPAWN_DELAY_BASE) * Math.random()) : MAX_SPAWN_DELAY_BASE - (MAX_SPAWN_DELAY_BASE - MIN_SPAWN_DELAY_BASE) / 2;
        if (this.getCapacitorType().ordinal() == 1) {
            ticksDelay /= 2;
        } else if (this.getCapacitorType().ordinal() == 2) {
            ticksDelay /= 4;
        }
        int powerPerTick = this.getPowerUsePerTick();
        res.setRequiredEnergy(powerPerTick * ticksDelay);
        return res;
    }

    protected boolean canSpawnEntity(EntityLiving entityliving) {
        boolean spaceClear;
        boolean bl = spaceClear = this.worldObj.checkNoEntityCollision(entityliving.boundingBox) && this.worldObj.getCollidingBoundingBoxes((Entity)entityliving, entityliving.boundingBox).isEmpty() && (!this.worldObj.isAnyLiquid(entityliving.boundingBox) || entityliving.isCreatureType(EnumCreatureType.waterCreature, false));
        if (spaceClear && USE_VANILLA_SPAWN_CHECKS) {
            spaceClear = entityliving.getCanSpawnHere();
        }
        return spaceClear;
    }

    Entity createEntity(boolean forceAlive) {
        Entity ent = EntityList.createEntityByName((String)this.getEntityName(), (World)this.worldObj);
        if (forceAlive && MIN_PLAYER_DISTANCE <= 0 && Config.poweredSpawnerDespawnTimeSeconds > 0 && ent instanceof EntityLiving) {
            ent.getEntityData().setLong("spawnedByPoweredSpawner", this.worldObj.getTotalWorldTime());
            ((EntityLiving)ent).func_110163_bv();
        }
        return ent;
    }

    protected boolean trySpawnEntity() {
        int nearbyEntities;
        Entity entity = this.createEntity(true);
        if (!(entity instanceof EntityLiving)) {
            return false;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        int spawnRange = Config.poweredSpawnerSpawnRange;
        if (Config.poweredSpawnerMaxNearbyEntities > 0 && (nearbyEntities = this.worldObj.getEntitiesWithinAABB(entity.getClass(), AxisAlignedBB.getBoundingBox((double)(this.xCoord - spawnRange * 2), (double)(this.yCoord - 4), (double)(this.zCoord - spawnRange * 2), (double)(this.xCoord + spawnRange * 2), (double)(this.yCoord + 4), (double)(this.zCoord + spawnRange * 2))).size()) >= Config.poweredSpawnerMaxNearbyEntities) {
            return false;
        }
        while (this.remainingSpawnTries-- > 0) {
            double x = (double)this.xCoord + (this.worldObj.rand.nextDouble() - this.worldObj.rand.nextDouble()) * (double)spawnRange;
            double y = this.yCoord + this.worldObj.rand.nextInt(3) - 1;
            double z = (double)this.zCoord + (this.worldObj.rand.nextDouble() - this.worldObj.rand.nextDouble()) * (double)spawnRange;
            entity.setLocationAndAngles(x, y, z, this.worldObj.rand.nextFloat() * 360.0f, 0.0f);
            if (!this.canSpawnEntity(entityliving)) continue;
            entityliving.onSpawnWithEgg(null);
            this.worldObj.spawnEntityInWorld((Entity)entityliving);
            this.worldObj.playAuxSFX(2004, this.xCoord, this.yCoord, this.zCoord, 0);
            entityliving.spawnExplosionParticle();
            return true;
        }
        return false;
    }

    public String getEntityName() {
        return this.entityTypeName;
    }

    public boolean hasEntityName() {
        return !NULL_ENTITY_NAME.equals(this.entityTypeName);
    }
}

