/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.spawner;

import com.enderio.core.client.handlers.SpecialTooltipHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class ItemBrokenSpawner
extends Item {
    private static final String[] CREATIVE_TYPES = new String[]{"Skeleton", "Zombie", "Spider", "CaveSpider", "Blaze", "Enderman", "Chicken"};

    public static String getMobTypeFromStack(ItemStack stack) {
        if (stack == null || stack.stackTagCompound == null || !stack.stackTagCompound.hasKey("mobType")) {
            return null;
        }
        return stack.stackTagCompound.getString("mobType");
    }

    public static ItemStack createStackForMobType(String mobType) {
        if (mobType == null) {
            return null;
        }
        ItemStack res = new ItemStack((Item)EnderIO.itemBrokenSpawner);
        res.stackTagCompound = new NBTTagCompound();
        res.stackTagCompound.setString("mobType", mobType);
        return res;
    }

    public static ItemBrokenSpawner create() {
        ItemBrokenSpawner result = new ItemBrokenSpawner();
        result.init();
        return result;
    }

    protected ItemBrokenSpawner() {
        this.setCreativeTab(EnderIOTab.tabEnderIO);
        this.setUnlocalizedName(ModObject.itemBrokenSpawner.unlocalisedName);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.setMaxStackSize(64);
    }

    public boolean isDamageable() {
        return false;
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)ModObject.itemBrokenSpawner.unlocalisedName);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iIconRegister) {
        this.itemIcon = iIconRegister.registerIcon("enderio:itemBrokenSpawner");
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (String mobType : CREATIVE_TYPES) {
            par3List.add(ItemBrokenSpawner.createStackForMobType(mobType));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (par1ItemStack != null && par1ItemStack.stackTagCompound != null) {
            String mobName = ItemBrokenSpawner.getMobTypeFromStack(par1ItemStack);
            if (mobName != null) {
                par3List.add(StatCollector.translateToLocal((String)("entity." + mobName + ".name")));
            }
            if (!SpecialTooltipHandler.showAdvancedTooltips()) {
                SpecialTooltipHandler.addShowDetailsTooltip((List)par3List);
            } else {
                SpecialTooltipHandler.addDetailedTooltipFromResources((List)par3List, (ItemStack)par1ItemStack);
            }
        }
    }
}

