/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.solar;

import cofh.api.energy.EnergyStorage;
import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.solar.SolarPanelNetwork;
import crazypants.enderio.power.IInternalPowerProvider;
import crazypants.enderio.power.IPowerInterface;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.enderio.waila.IWailaNBTProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySolarPanel
extends TileEntityEio
implements IInternalPowerProvider,
IWailaNBTProvider {
    private final List<Receptor> receptors = new ArrayList<Receptor>();
    private ListIterator<Receptor> receptorIterator = this.receptors.listIterator();
    private boolean receptorsDirty = true;
    private int lastCollectionValue = -1;
    private static final int CHECK_INTERVAL = 100;
    EnergyStorage destroyedNetworkBuffer = null;
    protected SolarPanelNetwork network = new SolarPanelNetwork();

    public void onNeighborBlockChange() {
        this.receptorsDirty = true;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from == ForgeDirection.DOWN;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getMaxEnergyStored();
    }

    @Override
    public int getMaxEnergyRecieved(ForgeDirection dir) {
        return 0;
    }

    @Override
    public int getEnergyStored() {
        return this.network.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.network.getMaxEnergyStored();
    }

    @Override
    public void setEnergyStored(int stored) {
        this.network.setEnergyStored(stored);
    }

    public void doUpdate() {
        if (this.worldObj.isRemote) {
            return;
        }
        this.collectEnergy();
        this.transmitEnergy();
        if (this.network.isValid()) {
            if (this.destroyedNetworkBuffer != null) {
                this.network.addBuffer(this.destroyedNetworkBuffer);
                this.destroyedNetworkBuffer = null;
            }
            this.network.onUpdate(this);
        }
        if (!this.network.isValid() || this.shouldDoWorkThisTick(20, 1) && this.network.addToNetwork(this)) {
            this.findNetwork();
        }
    }

    public void invalidate() {
        this.network.removeFromNetwork(this);
        super.invalidate();
    }

    private void findNetwork() {
        for (ForgeDirection dir : SolarPanelNetwork.VALID_CONS) {
            SolarPanelNetwork network;
            TileEntity te = new BlockCoord((TileEntity)this).getLocation(dir).getTileEntity((IBlockAccess)this.worldObj);
            if (te == null || !(te instanceof TileEntitySolarPanel) || !((TileEntitySolarPanel)te).canConnect(this) || (network = ((TileEntitySolarPanel)te).network) == null) continue;
            network.addToNetwork(this);
        }
        if (!this.network.isValid()) {
            this.network = new SolarPanelNetwork(this);
        }
    }

    private boolean canConnect(TileEntitySolarPanel other) {
        return this.getBlockMetadata() == other.getBlockMetadata();
    }

    private void collectEnergy() {
        if (this.canSeeSun()) {
            if (this.lastCollectionValue == -1 || this.shouldDoWorkThisTick(100)) {
                float fromSun = this.calculateLightRatio();
                this.lastCollectionValue = Math.round((float)this.getEnergyPerTick() * fromSun);
            }
            if (this.lastCollectionValue > 0) {
                this.network.setEnergyStored(Math.min(this.lastCollectionValue + this.network.getEnergyStored(), this.network.getMaxEnergyStored()));
            }
        }
    }

    private int getEnergyPerTick() {
        int meta = this.getBlockMetadata();
        if (meta == 0) {
            return Config.maxPhotovoltaicOutputRF;
        }
        return Config.maxPhotovoltaicAdvancedOutputRF;
    }

    float calculateLightRatio() {
        return TileEntitySolarPanel.calculateLightRatio(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    boolean canSeeSun() {
        return this.worldObj.canBlockSeeTheSky(this.xCoord, this.yCoord, this.zCoord);
    }

    public static float calculateLightRatio(World world, int x, int y, int z) {
        int lightValue = world.getSavedLightValue(EnumSkyBlock.Sky, x, y, z) - world.skylightSubtracted;
        float sunAngle = world.getCelestialAngleRadians(1.0f);
        sunAngle = sunAngle < (float)Math.PI ? (sunAngle += (0.0f - sunAngle) * 0.2f) : (sunAngle += ((float)Math.PI * 2 - sunAngle) * 0.2f);
        lightValue = Math.round((float)lightValue * MathHelper.cos((float)sunAngle));
        lightValue = MathHelper.clamp_int((int)lightValue, (int)0, (int)15);
        return (float)lightValue / 15.0f;
    }

    private boolean transmitEnergy() {
        int canTransmit = Math.min(this.getEnergyStored(), this.network.getMaxEnergyExtracted());
        int transmitted = 0;
        this.checkReceptors();
        if (!this.receptors.isEmpty() && !this.receptorIterator.hasNext()) {
            this.receptorIterator = this.receptors.listIterator();
        }
        int numReceptors = this.receptors.size();
        for (int appliedCount = 0; this.receptorIterator.hasNext() && canTransmit > 0 && appliedCount < numReceptors; ++appliedCount) {
            Receptor receptor = this.receptorIterator.next();
            IPowerInterface pp = receptor.receptor;
            if (pp != null && pp.getMinEnergyReceived(receptor.fromDir.getOpposite()) <= canTransmit) {
                int used = pp.recieveEnergy(receptor.fromDir.getOpposite(), canTransmit);
                transmitted += used;
                canTransmit -= used;
            }
            if (canTransmit <= 0) break;
            if (this.receptors.isEmpty() || this.receptorIterator.hasNext()) continue;
            this.receptorIterator = this.receptors.listIterator();
        }
        this.setEnergyStored(this.getEnergyStored() - transmitted);
        return transmitted > 0;
    }

    private void checkReceptors() {
        if (!this.receptorsDirty) {
            return;
        }
        this.receptors.clear();
        BlockCoord bc = new BlockCoord(this.xCoord, this.yCoord, this.zCoord);
        ForgeDirection dir = ForgeDirection.DOWN;
        BlockCoord checkLoc = bc.getLocation(dir);
        TileEntity te = this.worldObj.getTileEntity(checkLoc.x, checkLoc.y, checkLoc.z);
        IPowerInterface pi = PowerHandlerUtil.create(te);
        if (pi != null) {
            this.receptors.add(new Receptor(pi, dir));
        }
        this.receptorIterator = this.receptors.listIterator();
        this.receptorsDirty = false;
    }

    public void readCustomNBT(NBTTagCompound tag) {
        this.network.readFromNBT(this, tag);
    }

    public void writeCustomNBT(NBTTagCompound tag) {
        if (this.network.isValid() && this.network.shouldSave(this)) {
            this.network.writeToNBT(tag);
            tag.setInteger("rfCap", this.network.getMaxEnergyStored());
        }
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.func_148857_g());
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    public void setNetwork(SolarPanelNetwork network) {
        this.network = network;
    }

    public boolean isMaster() {
        return this.network.getMaster() == this;
    }

    @Override
    public void getData(NBTTagCompound tag) {
        if (this.network.isValid()) {
            this.network.getMaster().writeToNBT(tag);
        }
    }

    static class Receptor {
        IPowerInterface receptor;
        ForgeDirection fromDir;

        private Receptor(IPowerInterface rec, ForgeDirection fromDir) {
            this.receptor = rec;
            this.fromDir = fromDir;
        }
    }
}

