/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.solar;

import com.enderio.core.api.client.render.IRenderFace;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.ConnectedTextureRenderer;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.CustomCubeRenderer;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.client.render.RenderUtil;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.solar.BlockSolarPanel;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class SolarPanelRenderer
implements ISimpleBlockRenderingHandler {
    private ConnectedTextureRenderer ctr = new ConnectedTextureRenderer();

    public SolarPanelRenderer() {
        this.ctr.setMatchMeta(true);
        this.ctr.setSidesToRender(EnumSet.of(ForgeDirection.UP));
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        RenderUtil.bindBlockTexture();
        Tessellator tes = Tessellator.instance;
        float offset = -0.5f;
        tes.addTranslation(offset, 0.0f, offset);
        tes.startDrawingQuads();
        CubeRenderer.render((BoundingBox)new BoundingBox((Block)EnderIO.blockSolarPanel), (IIcon[])RenderUtil.getBlockTextures((Block)EnderIO.blockSolarPanel, (int)metadata), (boolean)false);
        tes.draw();
        GL11.glEnable((int)32823);
        GL11.glPolygonOffset((float)-1.0f, (float)-1.0f);
        tes.startDrawingQuads();
        tes.setColorRGBA_F(1.0f, 1.0f, 1.0f, 1.0f);
        this.renderBorder(null, 0, 0, 0, metadata);
        tes.draw();
        tes.addTranslation(-offset, 0.0f, -offset);
        GL11.glDisable((int)32823);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.renderStandardBlock(block, x, y, z);
        Tessellator.instance.addTranslation(0.0f, 1.0E-4f, 0.0f);
        int meta = world.getBlockMetadata(x, y, z);
        meta = MathHelper.clamp_int((int)meta, (int)0, (int)1);
        this.ctr.setEdgeTexture(EnderIO.blockSolarPanel.getBorderIcon(0, meta));
        CustomCubeRenderer.instance.setOverrideTexture(IconUtil.blankTexture);
        if (!renderer.hasOverrideBlockTexture()) {
            CustomCubeRenderer.instance.renderBlock(world, block, x, y, z, (IRenderFace)this.ctr);
        } else {
            CustomCubeRenderer.instance.renderBlock(world, block, x, y, z);
        }
        CustomCubeRenderer.instance.setOverrideTexture(null);
        Tessellator.instance.addTranslation(0.0f, -1.0E-4f, 0.0f);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    private void renderBorder(IBlockAccess blockAccess, int x, int y, int z, int meta) {
        IIcon texture = EnderIO.blockSolarPanel.getBorderIcon(0, meta);
        RenderUtil.renderConnectedTextureFace((IBlockAccess)blockAccess, (Block)EnderIO.blockSolarPanel, (int)x, (int)y, (int)z, (ForgeDirection)ForgeDirection.UP, (IIcon)texture, (blockAccess == null ? 1 : 0) != 0, (boolean)false, (boolean)false);
    }

    public int getRenderId() {
        return BlockSolarPanel.renderId;
    }
}

