/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.solar;

import cofh.api.energy.EnergyStorage;
import com.google.common.collect.Lists;
import crazypants.enderio.machine.solar.TileEntitySolarPanel;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class SolarPanelNetwork {
    private List<TileEntitySolarPanel> panels = Lists.newArrayList();
    private boolean empty = true;
    private EnergyStorage energy = new EnergyStorage(10000);
    public static final int ENERGY_PER = 10000;
    public static final EnumSet<ForgeDirection> VALID_CONS = EnumSet.of(ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST);

    public SolarPanelNetwork() {
    }

    SolarPanelNetwork(TileEntitySolarPanel initial) {
        this();
        this.panels.add(initial);
        this.empty = false;
    }

    void onUpdate(TileEntitySolarPanel panel) {
    }

    boolean addToNetwork(TileEntitySolarPanel panel) {
        if (panel.network == this && panel.network.isValid() && this.panels.contains(panel)) {
            return false;
        }
        if (panel.network == null || !panel.network.isValid() || panel.network == this) {
            if (!this.panels.contains(panel)) {
                this.panels.add(panel);
            }
            panel.setNetwork(this);
            this.updateEnergy();
        } else {
            SolarPanelNetwork other = panel.network;
            for (TileEntitySolarPanel otherPanel : other.panels) {
                this.panels.add(otherPanel);
                otherPanel.setNetwork(this);
            }
            this.updateEnergy();
            this.energy.setEnergyStored(this.energy.getEnergyStored() + other.energy.getEnergyStored());
            other.invalidate();
        }
        this.empty = false;
        return true;
    }

    void removeFromNetwork(TileEntitySolarPanel panel) {
        ArrayList neighbors = Lists.newArrayList();
        for (ForgeDirection dir : VALID_CONS) {
            TileEntity te = panel.getLocation().getLocation(dir).getTileEntity((IBlockAccess)panel.getWorldObj());
            if (te == null || !(te instanceof TileEntitySolarPanel)) continue;
            neighbors.add((TileEntitySolarPanel)te);
        }
        for (TileEntitySolarPanel te : neighbors) {
            int dist = this.energy.getEnergyStored() / neighbors.size();
            te.destroyedNetworkBuffer = new EnergyStorage(dist);
            te.destroyedNetworkBuffer.setEnergyStored(dist);
        }
        this.destroyNetwork();
    }

    private void updateEnergy() {
        this.energy.setCapacity(10000 * this.panels.size());
        this.energy.setMaxExtract(this.energy.getMaxEnergyStored());
    }

    void destroyNetwork() {
        for (TileEntitySolarPanel te : this.panels) {
            te.setNetwork(new SolarPanelNetwork());
        }
        this.invalidate();
    }

    private void invalidate() {
        this.panels.clear();
        this.empty = true;
    }

    public boolean isValid() {
        return !this.empty;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.isValid() ? this.energy.extractEnergy(maxExtract, simulate) : 0;
    }

    public int getEnergyStored() {
        return this.energy.getEnergyStored();
    }

    public int setEnergyStored(int energy) {
        if (this.isValid()) {
            this.energy.setEnergyStored(energy);
        }
        return this.energy.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energy.getMaxEnergyStored();
    }

    public int getMaxEnergyExtracted() {
        return this.energy.getMaxExtract();
    }

    public void addBuffer(EnergyStorage destroyedNetworkBuffer) {
        this.energy.receiveEnergy(destroyedNetworkBuffer.getEnergyStored(), false);
    }

    TileEntitySolarPanel getMaster() {
        return this.panels.get(0);
    }

    boolean shouldSave(TileEntitySolarPanel panel) {
        return this.getMaster() == panel;
    }

    public int size() {
        return this.panels.size();
    }

    void writeToNBT(NBTTagCompound tag) {
        tag.setBoolean("validSolar", true);
        this.energy.writeToNBT(tag);
    }

    void readFromNBT(TileEntitySolarPanel panel, NBTTagCompound tag) {
        if (tag.getBoolean("validSolar")) {
            this.energy.readFromNBT(tag);
            this.addToNetwork(panel);
        }
    }
}

